/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.java.template;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.ui.editors.templateEditor.AbstractTemplateEditor;
import org.eclipse.egf.pattern.ui.java.Activator;
import org.eclipse.egf.pattern.ui.java.editor.JavaTextEditor;
import org.eclipse.egf.pattern.ui.java.editor.JavaTextEditorHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTemplateEditor
extends AbstractTemplateEditor {
    private static final String TEMPLATE_FILE_EXTENTION = ".java";
    private IAnnotationModel javaAnnotationModel;
    private IFile templateFile;
    private Map<String, Map<Annotation, Position>> methodJavaAnnotations = new HashMap<String, Map<Annotation, Position>>();
    private static Map<String, Map<Annotation, Position>> METHODJAVAANNOTATIONS = new HashMap<String, Map<Annotation, Position>>();

    protected void createPages() {
        Pattern pattern = this.getPattern();
        this.addPatternChangeAdapter(pattern);
        EList methods = pattern.getMethods();
        try {
            this.templateFile = this.setPublicTemplateEditor(pattern, methods, TEMPLATE_FILE_EXTENTION);
        }
        catch (Exception e) {
            Activator.getDefault();
            Activator.log(e);
        }
        this.initProblems();
        this.divideByMethods();
        int i = 0;
        while (i < methods.size()) {
            this.createPage((PatternMethod)methods.get(i), pattern);
            ++i;
        }
        String patternName = pattern.getName();
        this.setTitle(patternName);
    }

    void createPage(PatternMethod method, Pattern pattern) {
        try {
            JavaTextEditor editor = new JavaTextEditor(pattern);
            this.addEditor(editor, method);
        }
        catch (Exception e) {
            Activator.getDefault().logError(e);
        }
    }

    protected void initProblems() {
        IEditorPart editorPart = this.openEditor;
        if (editorPart == null) {
            return;
        }
        JavaEditor javaEditor = (JavaEditor)editorPart;
        this.javaAnnotationModel = JavaTextEditorHelper.getAnnotationModel(javaEditor);
    }

    protected void divideByMethods() {
        this.methodJavaAnnotations.clear();
        METHODJAVAANNOTATIONS.clear();
        for (String key : this.startPositions.keySet()) {
            Position position = (Position)this.startPositions.get(key);
            int startOffset = position.offset;
            int endOffset = position.offset + position.length;
            HashMap<Annotation, Position> javaAnnotations = new HashMap<Annotation, Position>();
            if (this.javaAnnotationModel == null) continue;
            Iterator annotationIterator = this.javaAnnotationModel.getAnnotationIterator();
            while (annotationIterator.hasNext()) {
                Annotation annotation = (Annotation)annotationIterator.next();
                Position posi = this.javaAnnotationModel.getPosition(annotation);
                if (posi == null) continue;
                int offset = posi.offset;
                int length = posi.length;
                if (startOffset == 0 && offset == -1) {
                    javaAnnotations.put(annotation, posi);
                }
                if (offset < startOffset || offset > endOffset) continue;
                posi.setOffset(offset - startOffset);
                javaAnnotations.put(annotation, posi);
            }
            this.methodJavaAnnotations.put(key, javaAnnotations);
            METHODJAVAANNOTATIONS = this.methodJavaAnnotations;
        }
    }

    public static Map<String, Map<Annotation, Position>> getMethodJavaAnnotations() {
        return METHODJAVAANNOTATIONS;
    }

    public IEditorPart getTemplateFileEditorPart() {
        return this.openEditor;
    }

    public IFile getTemplateFile() {
        return this.templateFile;
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        JavaTextEditorHelper.mappingErrorFromTemplateEditor((JavaTextEditor)this.getActiveEditor());
    }

    public void setActivePage(String methodId) {
        JavaTextEditor javaTextEditor;
        if (methodId != null && !"".equals(methodId) && (javaTextEditor = (JavaTextEditor)((Object)this.editorMap.get(methodId))) != null) {
            this.setActiveEditor((IEditorPart)javaTextEditor);
        }
    }

    protected void executeMethodEditorAdd(PatternMethod addMethod) {
        try {
            if (addMethod.getID() == null) {
                return;
            }
            this.setPatternFilePath(addMethod);
            JavaTextEditor newEditor = new JavaTextEditor(this.getPattern());
            this.addEditor(newEditor, addMethod);
            super.executeMethodEditorAdd(addMethod);
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e);
        }
        catch (IOException e) {
            Activator.getDefault().logError(e);
        }
    }

    protected TextEditor createNewEditor() {
        try {
            JavaTextEditor newEditor = new JavaTextEditor(this.getPattern());
            return newEditor;
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e);
        }
        catch (IOException e) {
            Activator.getDefault().logError(e);
        }
        return null;
    }

    protected String getDelegateEditorID() {
        return "org.eclipse.jdt.ui.CompilationUnitEditor";
    }
}

