/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleHelper {
    private BundleHelper() {
    }

    public static Object instantiate(String fqcn, Bundle bundle) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (fqcn == null || fqcn.trim().length() == 0 || bundle == null) {
            return null;
        }
        Class<?> clazz = BundleHelper.loadClass(fqcn, bundle);
        if (clazz != null) {
            return clazz.newInstance();
        }
        return null;
    }

    public static Class<?> loadClass(String fqcn, Bundle bundle) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (fqcn == null || fqcn.trim().length() == 0 || bundle == null) {
            return clazz;
        }
        return bundle.loadClass(fqcn.trim());
    }

    public static String getBundleId(ModelEntry entry) {
        if (entry == null) {
            return null;
        }
        String id = entry.getId();
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        return id.trim();
    }

    public static String getBundleId(IPluginModelBase model) {
        if (model == null || model.getPluginBase() == null) {
            return null;
        }
        if (model.getUnderlyingResource() != null && model.getUnderlyingResource().getProject() != null) {
            return BundleHelper.getBundleId(model.getUnderlyingResource().getProject());
        }
        String id = model.getPluginBase().getId();
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        return id.trim();
    }

    public static String getBundleId(IProject project) {
        if (project == null) {
            return null;
        }
        String id = null;
        IPluginModelBase model = BundleHelper.getPluginModelBase(project);
        if (model != null) {
            id = model.getPluginBase().getId();
        }
        if (id == null) {
            id = project.getName();
        }
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        return id.trim();
    }

    public static String getBundleId(IResource resource) {
        if (resource == null) {
            return null;
        }
        return BundleHelper.getBundleId(resource.getProject());
    }

    public static IPluginModelBase getPluginModelBase(IPath path) {
        if (path == null || path.segmentCount() < 2) {
            return null;
        }
        return BundleHelper.getPluginModelBase(ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0)));
    }

    public static IPluginModelBase getPluginModelBase(IResource resource) {
        if (resource == null) {
            return null;
        }
        return BundleHelper.getPluginModelBase(resource.getProject());
    }

    public static IPluginModelBase getPluginModelBase(IProject project) {
        if (project == null) {
            return null;
        }
        return PluginRegistry.findModel((IProject)project);
    }

    public static Bundle getBundle(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return FrameworkUtil.getBundle(clazz);
    }
}

