/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

public class MathHelper {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;

    private MathHelper() {
    }

    public static String formatAsDuration(long duration) {
        long temp = 0L;
        long innerDuration = duration;
        StringBuilder formatted = new StringBuilder();
        temp = innerDuration / 86400000L;
        if (temp > 0L) {
            formatted.append(temp).append(" day");
            if (temp > 1L) {
                formatted.append("s");
            }
            innerDuration -= temp * 86400000L;
        }
        if ((temp = innerDuration / 3600000L) > 0L) {
            if (formatted.length() > 0) {
                formatted.append(" ");
            }
            formatted.append(temp).append(" hr");
            if (temp > 1L) {
                formatted.append("s");
            }
            innerDuration -= temp * 3600000L;
        }
        if ((temp = innerDuration / 60000L) > 0L) {
            if (formatted.length() > 0) {
                formatted.append(" ");
            }
            formatted.append(temp).append(" min");
            if (temp > 1L) {
                formatted.append("s");
            }
            innerDuration -= temp * 60000L;
        }
        if (innerDuration >= 1000L && (temp = innerDuration / 1000L) > 0L) {
            if (formatted.length() > 0) {
                formatted.append(" ");
            }
            formatted.append(temp).append(" sec");
            if (temp > 1L) {
                formatted.append("s");
            }
            innerDuration -= temp * 1000L;
        }
        if (innerDuration > 0L) {
            if (formatted.length() > 0) {
                formatted.append(" ");
            }
            formatted.append(innerDuration).append(" ms");
        }
        return formatted.toString();
    }

    public static int multiply(int sourceValue_p, float multiplier_p) {
        return (int)((float)sourceValue_p * multiplier_p);
    }
}

