/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.templateEditor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.editors.templateEditor.DocumentReader;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuessingProposal;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateEditorUtility {
    private static final String EMF_CODEGEN_JET_NATURE_ID = "org.eclipse.emf.codegen.jet.IJETNature";

    public static int getStartPosition(Map<String, Position> startPositions) {
        int startOffset = 0;
        if (startPositions == null || startPositions.size() == 0) {
            return startOffset;
        }
        Collection<Position> starts = startPositions.values();
        for (Position position : starts) {
            startOffset = startOffset + position.length + 1;
        }
        return startOffset;
    }

    public static int getSourceLength(InputStream inputstream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(inputstream));
        int length = 0;
        while (br.read() != -1) {
            ++length;
        }
        br.close();
        return length;
    }

    public static String[] getAllWords(ITextViewer viewer, int offset) {
        IDocument doc = viewer.getDocument();
        DocumentReader reader = new DocumentReader(doc, offset);
        char c = reader.readBackward();
        ArrayList<String> all = new ArrayList<String>(20);
        char currChar = c;
        currChar = TemplateEditorUtility.trimBlanksBackward(reader, currChar);
        boolean done = false;
        while (!done) {
            Stack<Character> stack = new Stack<Character>();
            while (currChar != '\uffff' && !Character.isWhitespace(currChar)) {
                stack.push(new Character(currChar));
                currChar = reader.readBackward();
            }
            String s = new String();
            while (!stack.empty()) {
                s = String.valueOf(s) + ((Character)stack.pop()).toString();
            }
            int jePt = s.indexOf("<%=");
            if (jePt >= 0) {
                s = s.substring(jePt + 3);
                done = true;
            } else {
                int jspPt = s.indexOf("<%");
                if (jspPt >= 0) {
                    s = s.substring(jspPt + 2);
                    done = true;
                }
            }
            all.add(s);
            currChar = TemplateEditorUtility.trimBlanksBackward(reader, currChar);
            if (currChar != '\uffff' && currChar != '@') continue;
            done = true;
        }
        return all.toArray(new String[all.size()]);
    }

    public static char trimBlanksBackward(DocumentReader reader, char currChar) {
        while (currChar != '\uffff' && Character.isWhitespace(currChar)) {
            currChar = reader.readBackward();
        }
        return currChar;
    }

    public static IClasspathEntry[] getNewIClasspathEntry(IClasspathEntry[] entries, IClasspathEntry[] jreEntry) {
        if (entries != null && jreEntry != null) {
            IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + jreEntry.length];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            System.arraycopy(jreEntry, 0, newEntries, entries.length, jreEntry.length);
            return newEntries;
        }
        return null;
    }

    public static void createFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                TemplateEditorUtility.createFolder((IFolder)parent, force, local, null);
            }
            folder.create(force, local, monitor);
        }
    }

    public static IJavaProject createJavaProject(String name, IProgressMonitor monitor) {
        IJavaProject javaProject = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(name);
        URI locationURI = project.getLocationURI();
        try {
            try {
                IClasspathEntry[] jreEntry;
                IClasspathEntry srcEntry;
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("Creating project...", 10);
                try {
                    if (!project.exists()) {
                        IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                        if (locationURI != null && ResourcesPlugin.getWorkspace().getRoot().getLocationURI().equals(locationURI)) {
                            locationURI = null;
                        }
                        desc.setLocationURI(locationURI);
                        TemplateEditorUtility.setProjectJET1Nature(desc);
                        project.create(desc, monitor);
                        monitor = null;
                    }
                    if (!project.isOpen()) {
                        project.open(monitor);
                        monitor = null;
                    }
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                    IProjectDescription description = project.getDescription();
                    String[] prevNatures = description.getNatureIds();
                    String[] newNatures = new String[prevNatures.length + 1];
                    System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
                    newNatures[prevNatures.length] = "org.eclipse.jdt.core.javanature";
                    description.setNatureIds(newNatures);
                    project.setDescription(description, monitor);
                } else if (monitor != null) {
                    monitor.worked(1);
                }
                ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
                IPath sourceFolderPath = new Path(name).makeAbsolute();
                Path srcPath = new Path(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName"));
                if (srcPath.segmentCount() > 0) {
                    sourceFolderPath = sourceFolderPath.append((IPath)srcPath);
                }
                if ((srcPath = (srcEntry = JavaCore.newSourceEntry((IPath)sourceFolderPath)).getPath()).segmentCount() > 1) {
                    IFolder folder = root.getFolder((IPath)srcPath);
                    TemplateEditorUtility.createFolder(folder, true, true, monitor);
                }
                cpEntries.add(srcEntry);
                IClasspathEntry[] iClasspathEntryArray = jreEntry = PreferenceConstants.getDefaultJRELibrary();
                int n = jreEntry.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    cpEntries.add(entry);
                    ++n2;
                }
                IPath outputLocationPath = new Path(name).makeAbsolute();
                Path binPath = new Path(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
                if (binPath.segmentCount() > 0) {
                    outputLocationPath = outputLocationPath.append((IPath)binPath);
                    IFolder folder = root.getFolder(outputLocationPath);
                    TemplateEditorUtility.createFolder(folder, true, true, monitor);
                }
                javaProject = JavaCore.create((IProject)project);
                javaProject.setRawClasspath(cpEntries.toArray(new IClasspathEntry[cpEntries.size()]), outputLocationPath, monitor);
            }
            catch (CoreException e) {
                Activator.getDefault().logError(e);
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return javaProject;
    }

    public static ICompletionProposal[] filterJavaMethodProposals(ICompletionProposal[] javaProposals) {
        if (javaProposals == null) {
            return null;
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        ICompletionProposal[] iCompletionProposalArray = javaProposals;
        int n = javaProposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal javaProposal = iCompletionProposalArray[n2];
            if (javaProposal instanceof ParameterGuessingProposal || !(javaProposal instanceof JavaMethodCompletionProposal)) {
                proposals.add(javaProposal);
            }
            ++n2;
        }
        return (ICompletionProposal[])proposals.toArray(new IJavaCompletionProposal[proposals.size()]);
    }

    private static void setProjectJET1Nature(IProjectDescription desc) {
        if (!desc.hasNature(EMF_CODEGEN_JET_NATURE_ID)) {
            String[] natureIds = new String[]{EMF_CODEGEN_JET_NATURE_ID};
            desc.setNatureIds(natureIds);
        }
    }
}

