/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.templateEditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.egf.common.helper.ExtensionPointHelper;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.pattern.ui.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateExtensionRegistry {
    protected static final String EXTENSION_POINT_EDITOR = "templateEditor";
    protected static final String EXTENSION_Id = "id";
    protected static final String EXTENSION_POINT_NATURE = "nature";
    private static Map<String, String> editors;

    public static String getEditor(Pattern pattern) {
        PatternNature nature = pattern.getNature();
        Map<String, String> editors = TemplateExtensionRegistry.getEditors();
        if (editors != null) {
            String name = nature.eClass().getName();
            return editors.get(name);
        }
        return null;
    }

    public static Map<String, String> getEditors() {
        if (editors == null) {
            editors = new HashMap<String, String>();
        }
        IConfigurationElement[] iConfigurationElementArray = ExtensionPointHelper.getConfigurationElements((String)Activator.getDefault().getPluginID(), (String)EXTENSION_POINT_EDITOR);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String editorId = ExtensionPointHelper.getAttributeValue((IConfigurationElement)configurationElement, (String)EXTENSION_Id);
            String natureName = ExtensionPointHelper.getAttributeValue((IConfigurationElement)configurationElement, (String)EXTENSION_POINT_NATURE);
            editors.put(natureName, editorId);
            ++n2;
        }
        return editors;
    }
}

