/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.common.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.model.fcore.NamedModelElement;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternExecutionReporter;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.PatternPreferences;
import org.eclipse.egf.pattern.engine.PatternEngine;
import org.eclipse.egf.pattern.execution.ConsoleReporter;
import org.eclipse.egf.pattern.execution.InternalPatternContext;
import org.eclipse.egf.pattern.utils.JavaMethodGenerationHelper;
import org.eclipse.egf.pattern.utils.ParameterTypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaEngine
extends PatternEngine {
    public AbstractJavaEngine(Pattern pattern) throws PatternException {
        super(pattern);
    }

    @Override
    public final void executeWithInjection(PatternContext context, Map<PatternParameter, Object> parameters) throws PatternException {
        this.setupExecutionReporter((InternalPatternContext)context);
        this.doExecute((InternalPatternContext)context, "orchestration", parameters);
    }

    @Override
    public final void execute(PatternContext context) throws PatternException {
        this.setupExecutionReporter((InternalPatternContext)context);
        this.doExecute((InternalPatternContext)context, "generate", null);
    }

    private void doExecute(InternalPatternContext context, String methodName, Map<PatternParameter, Object> parameters) throws PatternException {
        try {
            Class<?> templateClass = this.loadTemplateClass(context, this.getPatternClassname());
            Object template = templateClass.newInstance();
            Class[] parameterClasses = new Class[1];
            Object[] parameterValues = new Object[]{context};
            if ("generate".equals(methodName)) {
                parameterClasses[0] = Object.class;
            } else if ("orchestration".equals(methodName)) {
                parameterClasses[0] = PatternContext.class;
                Class[] setterClasses = new Class[1];
                Object[] setterValues = new Object[1];
                for (Map.Entry<PatternParameter, Object> entry : parameters.entrySet()) {
                    String setterMethod = JavaMethodGenerationHelper.getSetterMethod((NamedModelElement)entry.getKey());
                    String type = ParameterTypeHelper.INSTANCE.getTypeLiteral(entry.getKey().getType());
                    setterClasses[0] = this.loadTemplateClass(context, type);
                    setterValues[0] = entry.getValue();
                    Method method = templateClass.getMethod(setterMethod, setterClasses);
                    method.invoke(template, setterValues);
                }
            } else {
                throw new IllegalStateException();
            }
            Method method = templateClass.getMethod(methodName, parameterClasses);
            method.invoke(template, parameterValues);
        }
        catch (InvocationTargetException e) {
            throw new PatternException(e.getCause());
        }
        catch (PatternException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PatternException((Throwable)e);
        }
    }

    protected abstract String getPatternClassname() throws PatternException;

    private void setupExecutionReporter(InternalPatternContext context) throws PatternException {
        if (context.hasReporter()) {
            return;
        }
        PatternExecutionReporter reporter = (PatternExecutionReporter)context.getValue("pattern.execution.reporter");
        if (reporter == null) {
            reporter = new ConsoleReporter();
        }
        context.setReporter(reporter);
    }

    protected IPath computeFilePath(String classname) {
        String[] names;
        if (classname == null || "".equals(classname)) {
            throw new IllegalArgumentException();
        }
        Path result = new Path(PatternPreferences.getGenerationFolderName());
        String[] stringArray = names = classname.split("\\.");
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            result = result.append(name);
            ++n2;
        }
        result = result.addFileExtension("java");
        return result;
    }

    protected Class<?> loadTemplateClass(InternalPatternContext context, String type) throws PatternException, ClassNotFoundException {
        if (type == null) {
            throw new PatternException(Messages.assembly_error1);
        }
        Class templateClass = context.getBundle(this.getBundleId()).loadClass(type);
        return templateClass;
    }
}

