/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.ftask.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.helper.ExtensionPointHelper;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.model.EGFFtaskPlugin;
import org.eclipse.egf.model.ftask.Task;
import org.eclipse.egf.model.ftask.l10n.EGFFtaskMessages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface TaskHook {
    public static final String EXTENSION_ID = "org.eclipse.egf.model.ftask.task";
    public static final String INVOKER_ATT_CLASS = "class";
    public static final Helper HELPER = new Helper();

    public void invoke(Bundle var1, ITaskProductionContext var2, Task var3, IProgressMonitor var4) throws InvocationException;

    public String getKind();

    public boolean isLoadableImplementation(Task var1, Map<Object, Object> var2);

    public boolean isValidImplementation(Task var1, Map<Object, Object> var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Helper {
        private final Map<String, TaskHook> kind2hooks = new HashMap<String, TaskHook>();

        public List<String> getKinds() {
            return new ArrayList<String>(this.kind2hooks.keySet());
        }

        public TaskHook getHook(Task task) throws InvocationException {
            if (task == null) {
                throw new InvocationException(EGFFtaskMessages.missing_task_message);
            }
            if (task.getKindValue() == null || task.getKindValue().trim().length() == 0) {
                throw new InvocationException(NLS.bind((String)EGFFtaskMessages.missing_kind_message, (Object)EMFHelper.getText((Object)task)));
            }
            TaskHook taskHook = this.kind2hooks.get(task.getKindValue().trim());
            if (taskHook == null) {
                throw new InvocationException(NLS.bind((String)EGFFtaskMessages.missing_hook_message, (Object)task.getKindValue().trim()));
            }
            return taskHook;
        }

        private Helper() {
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(TaskHook.EXTENSION_ID);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    String extension = ExtensionPointHelper.getAttributeValue((IConfigurationElement)element, (String)TaskHook.INVOKER_ATT_CLASS);
                    if (extension != null && extension.trim().length() != 0) {
                        extension = extension.trim();
                        Object object = element.createExecutableExtension(TaskHook.INVOKER_ATT_CLASS);
                        if (object != null) {
                            if (!(object instanceof TaskHook)) {
                                EGFFtaskPlugin.getPlugin().logError(NLS.bind((String)"Wrong Class {0}", (Object)object.getClass().getName()));
                                EGFFtaskPlugin.getPlugin().logInfo(NLS.bind((String)"Class should be an implementation of ''{0}''.", (Object)TaskHook.class.getName()), 1);
                                EGFFtaskPlugin.getPlugin().logInfo(NLS.bind((String)"Bundle ''{0}''", (Object)ExtensionPointHelper.getNamespace((IConfigurationElement)element)), 1);
                                EGFFtaskPlugin.getPlugin().logInfo(NLS.bind((String)"Extension-Point ''{0}''", (Object)element.getName()), 1);
                                EGFFtaskPlugin.getPlugin().logInfo(NLS.bind((String)"extension ''{0}''", (Object)extension), 1);
                            } else {
                                TaskHook contributor = (TaskHook)object;
                                if (contributor.getKind() != null && contributor.getKind().trim().length() != 0) {
                                    String kind = contributor.getKind().trim();
                                    if (this.kind2hooks.get(kind) != null) {
                                        EGFFtaskPlugin.getPlugin().logError(NLS.bind((String)"Duplicate Kind ''{0}''", (Object)kind));
                                        EGFFtaskPlugin.getPlugin().logInfo(NLS.bind((String)"Extension-Point ''{0}''", (Object)element.getName()), 1);
                                        EGFFtaskPlugin.getPlugin().logInfo(NLS.bind((String)"Bundle ''{0}''", (Object)ExtensionPointHelper.getNamespace((IConfigurationElement)element)), 1);
                                    }
                                    this.kind2hooks.put(contributor.getKind(), contributor);
                                }
                            }
                        }
                    }
                }
                catch (CoreException e) {
                    EGFFtaskPlugin.getPlugin().logError(e);
                }
                ++n2;
            }
        }
    }
}

