/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.common.extensionpoint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPointException;
import org.eclipse.emf.emfstore.common.extensionpoint.Messages;
import org.eclipse.emf.emfstore.internal.common.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESExtensionPoint {
    private List<ESExtensionElement> elements;
    private final String id;
    private boolean exceptionInsteadOfNull;
    private Comparator<ESExtensionElement> comparator;

    public ESExtensionPoint(String id) {
        this(id, false);
    }

    public ESExtensionPoint(String id, boolean throwException) {
        this.id = id;
        this.exceptionInsteadOfNull = throwException;
        this.comparator = this.getDefaultComparator();
        this.reload();
    }

    public ESExtensionPoint(String id, boolean throwException, Comparator<ESExtensionElement> comparator) {
        this.id = id;
        this.exceptionInsteadOfNull = throwException;
        this.comparator = comparator;
        this.reload();
    }

    public void reload() {
        this.setElements(new ArrayList<ESExtensionElement>());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(this.id);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            this.getElements().add(new ESExtensionElement(element, this.exceptionInsteadOfNull));
            ++n2;
        }
        Collections.sort(this.getElements(), this.comparator);
    }

    protected List<ESExtensionElement> getElements() {
        return this.elements;
    }

    protected void setElements(List<ESExtensionElement> elements) {
        this.elements = elements;
    }

    protected Comparator<ESExtensionElement> getDefaultComparator() {
        return new Comparator<ESExtensionElement>(){

            @Override
            public int compare(ESExtensionElement o1, ESExtensionElement o2) {
                return 0;
            }
        };
    }

    public <T> T getClass(String classAttributeName, Class<T> returnType) {
        ESExtensionElement first = this.getElementWithHighestPriority();
        if (first != null) {
            return first.getClass(classAttributeName, returnType);
        }
        return (T)ESExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null, Messages.ESExtensionPoint_ValueNotFound);
    }

    public <T> List<T> getClasses(String classAttributeName, Class<T> returnType) {
        List<ESExtensionElement> extensionElements = this.getExtensionElements();
        ArrayList<T> result = new ArrayList<T>();
        for (ESExtensionElement extensionElement : extensionElements) {
            T res = extensionElement.getClass(classAttributeName, returnType);
            if (res == null) continue;
            result.add(res);
        }
        return result;
    }

    public Boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public Boolean getBoolean(String name, boolean defaultValue) {
        ESExtensionElement element = this.getElementWithHighestPriority();
        if (element != null) {
            return element.getBoolean(name, defaultValue);
        }
        ESExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null, Messages.ESExtensionPoint_ValueNotFound);
        return defaultValue;
    }

    public Integer getInteger(String name) {
        ESExtensionElement element = this.getElementWithHighestPriority();
        if (element != null) {
            return element.getInteger(name);
        }
        return (Integer)ESExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null, Messages.ESExtensionPoint_ValueNotFound);
    }

    public String getAttribute(String name) {
        ESExtensionElement element = this.getElementWithHighestPriority();
        if (element != null) {
            return element.getAttribute(name);
        }
        return (String)ESExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null, Messages.ESExtensionPoint_ValueNotFound);
    }

    public ESExtensionElement getElementWithHighestPriority() {
        return this.getFirst();
    }

    public void setComparator(Comparator<ESExtensionElement> comparator) {
        this.comparator = comparator;
    }

    public ESExtensionElement getFirst() {
        if (this.getElements().size() > 0) {
            return this.getElements().get(0);
        }
        return (ESExtensionElement)ESExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null, Messages.ESExtensionPoint_ValueNotFound);
    }

    public List<ESExtensionElement> getExtensionElements() {
        return Collections.unmodifiableList(this.getElements());
    }

    public ESExtensionPoint setThrowException(boolean b) {
        this.exceptionInsteadOfNull = b;
        return this;
    }

    protected static Object handleErrorOrNull(boolean useException, Exception expOrNull, String message) {
        if (useException) {
            if (expOrNull == null) {
                throw new ESExtensionPointException(message);
            }
            ESExtensionPoint.logException(expOrNull);
            throw new ESExtensionPointException(expOrNull);
        }
        return null;
    }

    protected static void logException(Exception e) {
        Activator.getDefault().logException(Messages.ESExtensionPoint_ExceptionOccurred, e);
    }

    public int size() {
        return this.getElements().size();
    }

    public String getId() {
        return this.id;
    }
}

