/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.emfstore.client.model.Activator;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.observers.ExceptionObserver;

public final class WorkspaceUtil {
    private WorkspaceUtil() {
    }

    public static void logException(String message, Exception e) {
        WorkspaceUtil.log(message, e, 4);
    }

    public static void logWarning(String message, Exception e) {
        WorkspaceUtil.log(message, e, 2);
    }

    public static void log(String message, Exception exception, int statusInt) {
        Activator activator = Activator.getDefault();
        Status status = new Status(statusInt, activator.getBundle().getSymbolicName(), statusInt, message, (Throwable)exception);
        activator.getLog().log((IStatus)status);
    }

    public static void handleException(String errorMessage, Exception exception) {
        WorkspaceUtil.wrapAndHandleException(errorMessage, exception);
    }

    public static void handleException(Exception exception) {
        WorkspaceUtil.wrapAndHandleException(exception.getMessage(), exception);
    }

    private static void wrapAndHandleException(String errorMessage, Exception exception) {
        RuntimeException runtimeException = new RuntimeException(errorMessage, exception);
        Boolean errorHandeled = ((ExceptionObserver)WorkspaceManager.getObserverBus().notify(ExceptionObserver.class)).handleError(runtimeException);
        WorkspaceUtil.logException("An error occured.", exception);
        if (!errorHandeled.booleanValue()) {
            throw runtimeException;
        }
    }
}

