/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server;

import java.util.TimerTask;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.core.MonitorProvider;
import org.eclipse.emf.emfstore.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanMemoryTask
extends TimerTask {
    private static final boolean LOG_UNLOADING = false;
    private static final Integer PREEMPTION_INTERVAL = 100;
    private static final Integer KEEP_CHANGES_PACKAGES = 25;
    private final ResourceSet resourceSet;

    public CleanMemoryTask(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    @Override
    public void run() {
        while (this.unloadSomethingIfRequired()) {
            try {
                Thread.sleep(PREEMPTION_INTERVAL.intValue());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean unloadSomethingIfRequired() {
        Object object = MonitorProvider.getInstance().getMonitor();
        synchronized (object) {
            EList resources = this.resourceSet.getResources();
            int i = 0;
            while (true) {
                if (i >= resources.size()) {
                    return false;
                }
                Resource res = (Resource)resources.get(i);
                if (res.isLoaded()) {
                    Version version;
                    Project project = this.getElement(res, Project.class);
                    if (project != null && (version = this.getParent((EObject)project, Version.class)) != null && version.getNextVersion() != null) {
                        this.log("unloading: " + project);
                        this.unload(res);
                        return true;
                    }
                    ChangePackage cp = this.getElement(res, ChangePackage.class);
                    if (cp != null) {
                        Version version2 = this.getParent((EObject)cp, Version.class);
                        ProjectHistory history = this.getParent((EObject)version2, ProjectHistory.class);
                        if (version2 != null && history != null && version2.getPrimarySpec().getIdentifier() <= history.getVersions().size() - KEEP_CHANGES_PACKAGES - 1) {
                            this.log("unloading: " + cp);
                            this.unload(res);
                            return true;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void log(String str) {
    }

    private <T> T getElement(Resource res, Class<T> clazz) {
        if (res.getContents().size() == 1 && clazz.isInstance(res.getContents().get(0))) {
            return (T)res.getContents().get(0);
        }
        return null;
    }

    private <T> T getParent(EObject obj, Class<T> clazz) {
        if (obj != null && obj.eContainer() != null && clazz.isInstance(obj.eContainer())) {
            return (T)obj.eContainer();
        }
        return null;
    }

    private void unload(Resource res) {
        if (res.getContents().size() != 1) {
            return;
        }
        EObject eObject = (EObject)res.getContents().get(0);
        res.unload();
        res.getResourceSet().getResources().remove((Object)res);
        if (eObject instanceof Project) {
            Project project = (Project)eObject;
            project.dispose();
        }
        if (!eObject.eIsProxy()) {
            ModelUtil.logWarning((String)("Couldn't unload: " + eObject));
            return;
        }
        for (EReference child : eObject.eClass().getEAllContainments()) {
            eObject.eUnset((EStructuralFeature)child);
        }
    }
}

