/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.action;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.action.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewOrgUnitDialog
extends Dialog {
    private final Set<String> fieldNames;
    private final Map<String, Text> fieldToTextMapping;
    private final Map<String, String> fieldValues;

    public NewOrgUnitDialog(Shell parentShell, Set<String> fieldNames) {
        super(parentShell);
        this.fieldNames = fieldNames;
        this.fieldToTextMapping = new LinkedHashMap<String, Text>();
        this.fieldValues = new LinkedHashMap<String, String>();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        StringBuilder builder = new StringBuilder(Messages.NewOrgUnitDialog_Title_Prefix);
        builder.append(StringUtils.join(this.fieldNames, (String)Messages.NewOrgUnitDialog_Title_JoinSeparator));
        newShell.setText(StringUtils.capitalize((String)builder.toString().toLowerCase()));
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        return new Point(450, 165);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)comp.getLayout();
        layout.numColumns = 2;
        for (String fieldName : this.fieldNames) {
            Label label = new Label(comp, 16384);
            label.setText(String.valueOf(fieldName) + ": ");
            Text text = new Text(comp, 2052);
            this.fieldToTextMapping.put(fieldName, text);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)text);
        }
        return comp;
    }

    protected void okPressed() {
        for (Map.Entry<String, Text> field : this.fieldToTextMapping.entrySet()) {
            this.fieldValues.put(field.getKey(), field.getValue().getText());
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.fieldValues.values().clear();
        super.cancelPressed();
    }

    public String getFieldValue(String fieldName) {
        return this.fieldValues.get(fieldName);
    }
}

