/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.util;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.epsilon.common.util.OperatingSystem;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.types.CellStr;
import org.eclipse.epsilon.emc.simulink.types.Complex;
import org.eclipse.epsilon.emc.simulink.types.HandleObject;
import org.eclipse.epsilon.emc.simulink.types.Struct;

public class MatlabEngineUtil {
    public static String[] resolvePaths() throws IllegalStateException, IllegalArgumentException {
        String[] pathsArr = new String[]{"", "", ""};
        MatlabEngineUtil.resolvePaths(pathsArr);
        return pathsArr;
    }

    public static void resolvePaths(String[] currentPaths) throws IllegalStateException, IllegalArgumentException {
        if (currentPaths == null || currentPaths.length < 3) {
            throw new IllegalArgumentException("Must provide [matlab_path], [library_path], [engine_jar_path].");
        }
        String matlabPath = currentPaths[0];
        String libraryPath = currentPaths[1];
        String engineJarPath = currentPaths[2];
        boolean emptyMatlabPath = StringUtil.isEmpty((String)matlabPath);
        boolean emptyLibraryPath = StringUtil.isEmpty((String)libraryPath);
        boolean emptyEngineJarPath = StringUtil.isEmpty((String)engineJarPath);
        if (emptyMatlabPath) {
            matlabPath = MatlabEngineUtil.getMatlabPathFromEnv();
            emptyMatlabPath = StringUtil.isEmpty((String)matlabPath);
        }
        if (!emptyMatlabPath) {
            if (emptyLibraryPath) {
                libraryPath = MatlabEngineUtil.getLibraryPathFromRoot(matlabPath);
                emptyLibraryPath = StringUtil.isEmpty((String)libraryPath);
            }
            if (emptyEngineJarPath) {
                engineJarPath = MatlabEngineUtil.getEngineJarPathFromRoot(matlabPath);
                emptyEngineJarPath = StringUtil.isEmpty((String)engineJarPath);
            }
        }
        if (emptyLibraryPath) {
            libraryPath = MatlabEngineUtil.getLibraryPathFromEnv();
            emptyLibraryPath = StringUtil.isEmpty((String)libraryPath);
        }
        if (emptyEngineJarPath) {
            engineJarPath = MatlabEngineUtil.getEngineJarPathFromEnv();
            emptyEngineJarPath = StringUtil.isEmpty((String)engineJarPath);
        }
        if (emptyLibraryPath || emptyEngineJarPath) {
            String errMsg = "Unresolved MATLAB environment variables.Please ensure that 'matlab_path' points to a valid MATLAB installation.Alternatively, specify the '";
            String singleSuffix = "' property.";
            String multiSuffix = "' properties.";
            if (emptyEngineJarPath && !emptyLibraryPath) {
                errMsg = String.valueOf(errMsg) + "engine_jar_path" + singleSuffix;
            }
            if (emptyLibraryPath && !emptyEngineJarPath) {
                errMsg = String.valueOf(errMsg) + "library_path" + singleSuffix;
            }
            if (emptyEngineJarPath && emptyLibraryPath) {
                errMsg = String.valueOf(errMsg) + "engine_jar_path and library_path" + multiSuffix;
            }
            throw new IllegalStateException(errMsg);
        }
        currentPaths[0] = matlabPath;
        currentPaths[1] = libraryPath;
        currentPaths[2] = engineJarPath;
    }

    public static String getLibraryPathFromRoot(String matlabPath) {
        String osBin;
        switch (OperatingSystem.getOSFamily()) {
            case WINDOWS: {
                osBin = "win64";
                break;
            }
            case MAC: {
                osBin = OperatingSystem.isARM64() ? "maca64" : "maci64";
                break;
            }
            default: {
                osBin = "glnxa64";
            }
        }
        return Paths.get(matlabPath, "bin", osBin).toAbsolutePath().toString();
    }

    public static String getEngineJarPathFromRoot(String matlabPath) {
        return Paths.get(matlabPath, "extern", "engines", "java", "jar", "engine.jar").toAbsolutePath().toString();
    }

    public static String getLibraryPathFromEnv() {
        return System.getenv("org.eclipse.epsilon.emc.library_path");
    }

    public static String getEngineJarPathFromEnv() {
        return System.getenv("org.eclipse.epsilon.emc.engine_jar_path");
    }

    public static String getMatlabPathFromEnv() {
        String matlabPath = null;
        matlabPath = System.getenv("org.eclipse.epsilon.emc.matlab_path");
        if (StringUtil.isEmpty((String)matlabPath) && StringUtil.isEmpty((String)(matlabPath = System.getenv("MATLAB_HOME"))) && StringUtil.isEmpty((String)(matlabPath = System.getenv("matlabroot")))) {
            File[] subDirs;
            File root;
            switch (OperatingSystem.getOSFamily()) {
                case WINDOWS: {
                    root = Paths.get("C:", "Program Files", "MATLAB").toFile();
                    break;
                }
                case MAC: {
                    root = new File("/Applications");
                    break;
                }
                default: {
                    root = new File("/usr/local/MATLAB");
                }
            }
            if (root != null && root.exists() && (subDirs = root.listFiles(OperatingSystem.isMac() ? (file, name) -> name.startsWith("MATLAB_") && name.endsWith(".app") && file.isDirectory() : null)).length > 0) {
                matlabPath = subDirs[subDirs.length - 1].getAbsolutePath().toString();
            }
        }
        return matlabPath;
    }

    public static List<Double> matlabArrayToList(double[] value) {
        ArrayList<Double> result = new ArrayList<Double>(value.length);
        int i = 0;
        while (i < value.length) {
            result.add(value[i]);
            ++i;
        }
        return result;
    }

    public static List<Long> matlabArrayToList(long[] value) {
        ArrayList<Long> result = new ArrayList<Long>(value.length);
        int i = 0;
        while (i < value.length) {
            result.add(value[i]);
            ++i;
        }
        return result;
    }

    public static List<Integer> matlabArrayToList(int[] value) {
        ArrayList<Integer> result = new ArrayList<Integer>(value.length);
        int i = 0;
        while (i < value.length) {
            result.add(value[i]);
            ++i;
        }
        return result;
    }

    public static List<Float> matlabArrayToList(float[] value) {
        ArrayList<Float> result = new ArrayList<Float>(value.length);
        int i = 0;
        while (i < value.length) {
            result.add(Float.valueOf(value[i]));
            ++i;
        }
        return result;
    }

    public static List<Boolean> matlabArrayToList(boolean[] value) {
        ArrayList<Boolean> result = new ArrayList<Boolean>(value.length);
        int i = 0;
        while (i < value.length) {
            result.add(value[i]);
            ++i;
        }
        return result;
    }

    public static List<Byte> matlabArrayToList(byte[] value) {
        ArrayList<Byte> result = new ArrayList<Byte>(value.length);
        int i = 0;
        while (i < value.length) {
            result.add(value[i]);
            ++i;
        }
        return result;
    }

    public static List<Short> matlabArrayToList(short[] value) {
        ArrayList<Short> result = new ArrayList<Short>(value.length);
        int i = 0;
        while (i < value.length) {
            result.add(value[i]);
            ++i;
        }
        return result;
    }

    public static <T> List<T> matlabArrayToList(Object[] value) {
        Object[] newValue = value;
        ArrayList<Object> result = new ArrayList<Object>(value.length);
        int i = 0;
        while (i < newValue.length) {
            result.add(newValue[i]);
            ++i;
        }
        return result;
    }

    public static Object parseMatlabEngineVariable(MatlabEngine engine, String variableName) throws MatlabException {
        return engine.getVariable(variableName);
    }

    public static Object formatForMatlabEngine(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ISimulinkModelElement) {
            return ((ISimulinkModelElement)value).getHandle();
        }
        if (value instanceof HandleObject) {
            return ((HandleObject)value).getHandleObject();
        }
        if (value instanceof String) {
            return ((String)value).toCharArray();
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            int size = collection.size();
            Object first = collection.iterator().next();
            if (first instanceof Byte) {
                return collection.toArray(new Byte[size]);
            }
            if (first instanceof Short) {
                return collection.toArray(new Short[size]);
            }
            if (first instanceof Integer) {
                return collection.toArray(new Integer[size]);
            }
            if (first instanceof Long) {
                return collection.toArray(new Long[size]);
            }
            if (first instanceof Long) {
                return collection.toArray(new Long[size]);
            }
            if (first instanceof Double) {
                return collection.toArray(new Double[size]);
            }
            if (first instanceof Boolean) {
                return collection.toArray(new Boolean[size]);
            }
            if (first instanceof String) {
                return collection.toArray(new String[size]);
            }
            if (first instanceof HandleObject) {
                return collection.stream().map(c -> ((HandleObject)c).getHandleObject()).toArray();
            }
            if (first instanceof ISimulinkModelElement) {
                return collection.stream().map(s -> ((ISimulinkModelElement)s).getHandle()).toArray();
            }
        }
        return value;
    }

    public static Object parseMatlabEngineVariable(Object value) {
        if (value == null) {
            return null;
        }
        if (HandleObject.is(value)) {
            return new HandleObject(value);
        }
        if (value instanceof byte[]) {
            return MatlabEngineUtil.matlabArrayToList((byte[])value);
        }
        if (value instanceof short[]) {
            return MatlabEngineUtil.matlabArrayToList((short[])value);
        }
        if (value instanceof int[]) {
            return MatlabEngineUtil.matlabArrayToList((int[])value);
        }
        if (value instanceof long[]) {
            return MatlabEngineUtil.matlabArrayToList((long[])value);
        }
        if (value instanceof float[]) {
            return MatlabEngineUtil.matlabArrayToList((float[])value);
        }
        if (value instanceof double[]) {
            return MatlabEngineUtil.matlabArrayToList((double[])value);
        }
        if (value instanceof boolean[]) {
            return MatlabEngineUtil.matlabArrayToList((boolean[])value);
        }
        if (value instanceof String[]) {
            return MatlabEngineUtil.matlabArrayToList((String[])value);
        }
        if (value instanceof Object[]) {
            List<Object> l = Arrays.asList((Object[])value);
            if (l.stream().allMatch(HandleObject::is)) {
                return l.stream().map(HandleObject::new).collect(Collectors.toList());
            }
            if (l.stream().allMatch(Complex::is)) {
                return l.stream().map(Complex::new).collect(Collectors.toList());
            }
            if (l.stream().allMatch(Struct::is)) {
                return l.stream().map(Struct::new).collect(Collectors.toList());
            }
            if (l.stream().allMatch(CellStr::is)) {
                return l.stream().map(CellStr::new).collect(Collectors.toList());
            }
        }
        if (value instanceof Character) {
            return String.valueOf(value);
        }
        if (value instanceof String) {
            return String.valueOf(value);
        }
        if (Struct.is(value)) {
            return new Struct(value);
        }
        if (Complex.is(value)) {
            return new Complex(value);
        }
        if (CellStr.is(value)) {
            return new CellStr(value);
        }
        return value;
    }
}

