/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cssparser.parser.media;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.htmlunit.cssparser.dom.Property;
import org.htmlunit.cssparser.parser.AbstractLocatable;

public class MediaQuery
extends AbstractLocatable
implements Serializable {
    private String media_;
    private final List<Property> properties_;
    private boolean implicitAll_;
    private final boolean isOnly_;
    private final boolean isNot_;

    public MediaQuery(String media) {
        this(media, false, false);
    }

    public MediaQuery(String media, boolean isOnly, boolean isNot) {
        this.media_ = media;
        if (media == null) {
            this.implicitAll_ = true;
            this.media_ = "all";
        }
        this.properties_ = new ArrayList<Property>(10);
        this.isOnly_ = isOnly;
        this.isNot_ = isNot;
    }

    public String getMedia() {
        return this.media_;
    }

    public List<Property> getProperties() {
        return this.properties_;
    }

    public void addMediaProperty(Property mp) {
        this.properties_.add(mp);
    }

    public boolean isOnly() {
        return this.isOnly_;
    }

    public boolean isNot() {
        return this.isNot_;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean hasMedia = false;
        if (this.isOnly_) {
            sb.append("only ");
            sb.append(this.getMedia());
            hasMedia = true;
        } else if (this.isNot_) {
            sb.append("not ");
            sb.append(this.getMedia());
            hasMedia = true;
        } else if (!this.implicitAll_) {
            sb.append(this.getMedia());
            hasMedia = true;
        }
        for (Property prop : this.properties_) {
            if (hasMedia) {
                sb.append(" and ");
            } else {
                hasMedia = true;
            }
            sb.append("(");
            sb.append(prop.toString());
            sb.append(')');
        }
        return sb.toString();
    }
}

