/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.framework.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.eclipse.gemini.management.internal.OSGiProperties;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.framework.ServiceStateMBean;

public final class OSGiService {
    private long bundle;
    private long identifier;
    private String[] interfaces;
    private Long[] usingBundles;
    private TabularData properties;

    public OSGiService(ServiceReference<?> reference) {
        this.bundle = reference.getBundle().getBundleId();
        this.identifier = (Long)reference.getProperty("service.id");
        this.interfaces = (String[])reference.getProperty("objectClass");
        this.properties = OSGiProperties.tableFrom(reference);
        this.usingBundles = this.longArrayFrom(OSGiService.getBundlesUsing(reference));
    }

    private Long[] longArrayFrom(long[] array) {
        if (array == null) {
            return new Long[0];
        }
        Long[] result = new Long[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i];
            ++i;
        }
        return result;
    }

    public static long[] getBundlesUsing(ServiceReference<?> serviceRef) {
        Bundle[] bundles = serviceRef.getUsingBundles();
        if (bundles == null) {
            return new long[0];
        }
        long[] ids = new long[bundles.length];
        int i = 0;
        while (i < bundles.length) {
            ids[i] = bundles[i].getBundleId();
            ++i;
        }
        return ids;
    }

    public static TabularData tableFrom(List<OSGiService> services) {
        TabularDataSupport table = new TabularDataSupport(ServiceStateMBean.SERVICES_TYPE);
        for (OSGiService service : services) {
            table.put(service.asCompositeData());
        }
        return table;
    }

    public static TabularData tableFrom(List<OSGiService> services, String ... serviceTypeItems) throws IOException {
        List<String> serviceTypes = Arrays.asList(serviceTypeItems);
        TabularDataSupport table = new TabularDataSupport(ServiceStateMBean.SERVICES_TYPE);
        for (OSGiService service : services) {
            table.put(service.asCompositeData(serviceTypes));
        }
        return table;
    }

    public CompositeData asCompositeData() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("BundleIdentifier", this.bundle);
        items.put("Identifier", this.identifier);
        items.put("objectClass", this.interfaces);
        items.put("Properties", this.properties);
        items.put("UsingBundles", this.usingBundles);
        try {
            return new CompositeDataSupport(ServiceStateMBean.SERVICE_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form service open data", e);
        }
    }

    private CompositeData asCompositeData(List<String> serviceTypes) {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Identifier", this.identifier);
        items.put("BundleIdentifier", serviceTypes.contains("BundleIdentifier") ? Long.valueOf(this.bundle) : null);
        items.put("objectClass", serviceTypes.contains("objectClass") ? this.interfaces : null);
        items.put("UsingBundles", serviceTypes.contains("UsingBundles") ? this.usingBundles : null);
        items.put("Properties", serviceTypes.contains("Properties") ? this.properties : null);
        try {
            return new CompositeDataSupport(ServiceStateMBean.SERVICE_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form service open data", e);
        }
    }
}

