/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.MethodAdapter;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.asm.commons.EmptyVisitor;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.AnnotationAttributesReadingVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MethodMetadataReadingVisitor
extends MethodAdapter
implements MethodMetadata {
    private final String name;
    private final int access;
    private final ClassLoader classLoader;
    private final Map<String, Map<String, Object>> attributeMap = new LinkedHashMap<String, Map<String, Object>>();

    public MethodMetadataReadingVisitor(String name, int access, ClassLoader classLoader) {
        super((MethodVisitor)new EmptyVisitor());
        this.name = name;
        this.access = access;
        this.classLoader = classLoader;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String className = Type.getType((String)desc).getClassName();
        return new AnnotationAttributesReadingVisitor(className, this.attributeMap, null, this.classLoader);
    }

    @Override
    public String getMethodName() {
        return this.name;
    }

    @Override
    public boolean isStatic() {
        return (this.access & 8) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.access & 0x10) != 0;
    }

    @Override
    public boolean isOverridable() {
        return !this.isStatic() && !this.isFinal() && (this.access & 2) == 0;
    }

    @Override
    public boolean isAnnotated(String annotationType) {
        return this.attributeMap.containsKey(annotationType);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        return this.attributeMap.get(annotationType);
    }
}

