/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.ui.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.StatusUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.controls.IPathUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.controls.Messages;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.controls.NewFileAction;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SelectFileControl
extends Composite {
    private final ViewerFilter VIEWER_FILTER = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof IResource)) {
                return false;
            }
            if (element instanceof IContainer) {
                IContainer container = (IContainer)element;
                if (!SelectFileControl.this.myOnlyExisting) {
                    return true;
                }
                boolean has = this.hasMatchingChildrenRecursive(container, SelectFileControl.this.myResourceFilter);
                return has;
            }
            return this.resourceMatches(SelectFileControl.this.myResourceFilter, (IResource)element);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean hasMatchingChildrenRecursive(IContainer container, IFilter filter) {
            try {
                IResource[] members;
                IResource[] iResourceArray = members = container.members();
                int n = members.length;
                int n2 = 0;
                while (true) {
                    boolean has;
                    if (n2 >= n) {
                        return false;
                    }
                    IResource member = iResourceArray[n2];
                    if (this.resourceMatches(filter, member)) {
                        return true;
                    }
                    if (member instanceof IContainer && (has = this.hasMatchingChildrenRecursive((IContainer)member, filter))) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        private boolean resourceMatches(IFilter filter, IResource member) {
            return filter == null || filter.accept(member);
        }
    };
    private static final ViewerSorter VIEWER_SORTER = new ViewerSorter(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            boolean folderLeft = e1 instanceof IContainer;
            boolean folderRight = e2 instanceof IContainer;
            if (folderLeft == folderRight) {
                return super.compare(viewer, e1, e2);
            }
            return folderLeft ? -1 : 1;
        }
    };
    private final ISelectionChangedListener VIEWER_LISTENER = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            try {
                IResource resource;
                SelectFileControl.this.myFileNameText.removeModifyListener(SelectFileControl.this.FNAME_LISTENER);
                if (selection == null) {
                    resource = null;
                    SelectFileControl.this.myFileNameText.setText("");
                } else {
                    resource = (IResource)selection.getFirstElement();
                    if (resource instanceof IFile) {
                        SelectFileControl.this.myFileNameText.setText(resource.getName());
                        SelectFileControl.this.myFileNameText.setEnabled(false);
                    } else if (SelectFileControl.this.myOnlyExisting) {
                        SelectFileControl.this.myFileNameText.setText("");
                        SelectFileControl.this.myFileNameText.setEnabled(false);
                    } else {
                        IFile file;
                        SelectFileControl.this.myFileNameText.setEnabled(true);
                        IPath computePath = IPathUtils.computePath(SelectFileControl.this.myResource, SelectFileControl.this.myFileNameText.getText());
                        if (computePath != null && SelectFileControl.this.myDefaultFileName != null && (file = WorkspaceUtils.getWorkspaceFile((String)computePath.toString())) != null && file.exists()) {
                            SelectFileControl.this.myFileNameText.setText(SelectFileControl.this.myDefaultFileName);
                        }
                    }
                }
                SelectFileControl.this.myResource = resource;
                SelectFileControl.this.myPath = IPathUtils.computePath(SelectFileControl.this.myResource, SelectFileControl.this.myFileNameText.getText());
                SelectFileControl.this.fileSelectionChanged(SelectFileControl.this.myPath);
            }
            finally {
                SelectFileControl.this.myFileNameText.addModifyListener(SelectFileControl.this.FNAME_LISTENER);
            }
        }
    };
    private final ModifyListener FNAME_LISTENER = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            SelectFileControl.this.myFileName = SelectFileControl.this.myFileNameText.getText();
            SelectFileControl.this.myPath = IPathUtils.computePath(SelectFileControl.this.myResource, SelectFileControl.this.myFileName);
            SelectFileControl.this.fileSelectionChanged(SelectFileControl.this.myPath);
        }
    };
    private final boolean myOnlyExisting;
    private TreeViewer myViewer;
    private Text myFileNameText;
    private String myFileName;
    private String myDefaultFileName;
    private final IFilter myResourceFilter;
    private IResource myResource;
    private IPath myPath;
    private final Set<IFile> myCreatedFiles;
    private final List<ISelectionListener> mySelectionListeners;
    private static final int DEFAUL_AUTO_EXPAND_LEVEL = 0;
    private static final String NAME_COLUMN = "name";
    private static final String DEFAULT_FNAME = "New File";
    private final ICellModifier FILE_CELL_MODIFIER = new ICellModifier(){

        public boolean canModify(Object element, String property) {
            return element instanceof IFile && SelectFileControl.this.myCreatedFiles.contains(element);
        }

        public Object getValue(Object element, String property) {
            if (!(element instanceof IFile) || !SelectFileControl.NAME_COLUMN.equals(property)) {
                return null;
            }
            return ((IFile)element).getName();
        }

        public void modify(Object element, String property, Object value) {
            IFile newFile;
            if (!(element instanceof TreeItem) || !SelectFileControl.NAME_COLUMN.equals(property)) {
                return;
            }
            Object data = ((TreeItem)element).getData();
            if (!(data instanceof IFile)) {
                return;
            }
            IFile file = (IFile)data;
            String newName = (String)value;
            if (newName == null || newName.length() == 0) {
                return;
            }
            if (file.getName().equals(newName)) {
                return;
            }
            IStatus status = file.getProject().getWorkspace().validateName(newName, 1);
            if (StatusUtil.isError((IStatus)status)) {
                Logger.getLogger().log(Logger.WARNING, "Validation failed for " + newName + ": " + status.getMessage());
                return;
            }
            Path newPath = new Path(newName);
            try {
                newFile = file.getParent().getFile((IPath)newPath);
            }
            catch (Exception e) {
                Logger.getLogger().log(Logger.WARNING, "Failed to get file " + newPath + "parent= " + file.getParent(), e);
                return;
            }
            if (!newFile.getParent().equals((Object)file.getParent())) {
                return;
            }
            if (newFile.exists()) {
                return;
            }
            SelectFileControl.this.removeCreatedFile(file);
            SelectFileControl.this.addCreatedFile(newFile);
            SelectFileControl.this.myViewer.refresh();
            SelectFileControl.this.myViewer.setSelection((ISelection)new StructuredSelection((Object)newFile));
        }
    };
    private ITreeContentProvider CONTENT_PROVIDER = new ITreeContentProvider(){
        ITreeContentProvider myProvider = new WorkbenchContentProvider();

        public Object[] getChildren(Object parentElement) {
            Object[] children = this.myProvider.getChildren(parentElement);
            if (SelectFileControl.this.myOnlyExisting) {
                return children;
            }
            if (!(parentElement instanceof IContainer)) {
                return children;
            }
            ArrayList<Object> allChildren = new ArrayList<Object>();
            if (children != null) {
                allChildren.addAll(Arrays.asList(children));
            }
            IContainer container = (IContainer)parentElement;
            allChildren.addAll(this.getCreatedChildren(container));
            return allChildren.toArray();
        }

        private List<Object> getCreatedChildren(IContainer container) {
            ArrayList<Object> children = new ArrayList<Object>();
            for (IFile file : SelectFileControl.this.myCreatedFiles) {
                if (!container.equals((Object)file.getParent())) continue;
                children.add(file);
            }
            return children;
        }

        public Object getParent(Object element) {
            Object parent = this.myProvider.getParent(element);
            if (parent != null) {
                return parent;
            }
            if (!(element instanceof IFile)) {
                return null;
            }
            IFile file = (IFile)element;
            return file.getParent();
        }

        public boolean hasChildren(Object element) {
            if (this.myProvider.hasChildren(element)) {
                return true;
            }
            if (!(element instanceof IContainer)) {
                return false;
            }
            return !this.getCreatedChildren((IContainer)element).isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            return this.myProvider.getElements(inputElement);
        }

        public void dispose() {
            this.myProvider.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.myProvider.inputChanged(viewer, oldInput, newInput);
        }
    };

    public SelectFileControl(Composite parentComposite, boolean onlyExisting, IFilter resourceFilter) {
        this(parentComposite, DEFAULT_FNAME, DEFAULT_FNAME, onlyExisting, resourceFilter);
    }

    public SelectFileControl(Composite parentComposite, String fileName, String defaultFileName, boolean onlyExisting, IFilter resourceFilter) {
        super(parentComposite, 0);
        this.myResourceFilter = resourceFilter;
        this.mySelectionListeners = new ArrayList<ISelectionListener>();
        this.myOnlyExisting = onlyExisting;
        this.myDefaultFileName = defaultFileName == null ? DEFAULT_FNAME : defaultFileName;
        this.myFileName = fileName == null ? this.myDefaultFileName : fileName;
        this.myCreatedFiles = new HashSet<IFile>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.setLayout((Layout)new GridLayout());
        this.myViewer = new TreeViewer((Composite)this, 2820);
        Label secondLabel = new Label((Composite)this, 16384);
        secondLabel.setText(Messages.SelectFileControl_SelectedFile);
        this.myFileNameText = new Text((Composite)this, 2048);
        this.myFileNameText.setEnabled(!this.myOnlyExisting);
        this.myFileNameText.setLayoutData((Object)new GridData(768));
        this.myFileNameText.setText(this.myFileName);
        this.myFileNameText.addModifyListener(this.FNAME_LISTENER);
        this.myViewer.setContentProvider((IContentProvider)this.CONTENT_PROVIDER);
        this.myViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.myViewer.setAutoExpandLevel(0);
        this.myViewer.addFilter(this.VIEWER_FILTER);
        this.myViewer.setSorter(VIEWER_SORTER);
        this.myViewer.addSelectionChangedListener(this.VIEWER_LISTENER);
        this.myViewer.setColumnProperties(new String[]{NAME_COLUMN});
        Tree tree = (Tree)this.myViewer.getControl();
        this.myViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)tree, 2052)});
        this.myViewer.setCellModifier(this.FILE_CELL_MODIFIER);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.heightHint = 250;
        data.widthHint = 350;
        this.myViewer.getControl().setLayoutData((Object)data);
        this.myViewer.setInput((Object)root);
        this.hookContextMenu();
    }

    void addCreatedFile(IFile file) {
        this.myCreatedFiles.add(file);
    }

    void removeCreatedFile(IFile file) {
        this.myCreatedFiles.remove(file);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SelectFileControl.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.myViewer.getControl());
        this.myViewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        if (!this.myOnlyExisting) {
            this.addNewFileAction(manager);
        }
    }

    private void addNewFileAction(IMenuManager manager) {
        ISelection selection = this.myViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object obj = structuredSelection.iterator().next();
        if (!(obj instanceof IContainer)) {
            return;
        }
        IContainer cont = (IContainer)obj;
        NewFileAction newFileAction = new NewFileAction(this, cont, this.myDefaultFileName);
        newFileAction.setText(Messages.SelectFileControl_NewFile);
        newFileAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        manager.add((IAction)newFileAction);
    }

    public void addSelectionListener(ISelectionListener listener) {
        this.mySelectionListeners.add(listener);
    }

    public void removeSelectionListener(ISelectionListener listener) {
        this.mySelectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.myViewer.setSelection(selection);
    }

    private void fileSelectionChanged(IPath selectedPath) {
        for (ISelectionListener listener : new ArrayList<ISelectionListener>(this.mySelectionListeners)) {
            try {
                listener.selectionChanged(selectedPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public TreeViewer getViewer() {
        return this.myViewer;
    }

    public IPath getSelectedPath() {
        return this.myPath;
    }

    public IFile getSelectedFile() {
        return this.myPath == null ? null : WorkspaceUtils.getWorkspaceFile((String)this.myPath.toString());
    }

    public void selectFileByPath(String path) {
        IFile file = WorkspaceUtils.getWorkspaceFile((String)path);
        if (file != null) {
            StructuredSelection sel = new StructuredSelection(new Object[]{file});
            this.myViewer.setSelection((ISelection)sel);
        }
    }

    public static interface IFilter {
        public boolean accept(IResource var1);
    }

    public static interface ISelectionListener {
        public void selectionChanged(IPath var1);
    }
}

