/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.Handler;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.impl.ProtonLinkImpl;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Record;

public class ProtonDeliveryImpl
implements ProtonDelivery {
    private final Delivery delivery;
    private Handler<ProtonDelivery> handler;
    private boolean autoSettle;

    ProtonDeliveryImpl(Delivery delivery) {
        this.delivery = delivery;
        delivery.setContext(this);
    }

    public ProtonLinkImpl getLink() {
        return (ProtonLinkImpl)this.delivery.getLink().getContext();
    }

    public void clear() {
        this.delivery.clear();
    }

    @Override
    public DeliveryState getLocalState() {
        return this.delivery.getLocalState();
    }

    @Override
    public boolean isSettled() {
        return this.delivery.isSettled();
    }

    @Override
    public boolean remotelySettled() {
        return this.delivery.remotelySettled();
    }

    @Override
    public Record attachments() {
        return this.delivery.attachments();
    }

    @Override
    public byte[] getTag() {
        return this.delivery.getTag();
    }

    public void setDefaultDeliveryState(DeliveryState state) {
        this.delivery.setDefaultDeliveryState(state);
    }

    public DeliveryState getDefaultDeliveryState() {
        return this.delivery.getDefaultDeliveryState();
    }

    public boolean isReadable() {
        return this.delivery.isReadable();
    }

    public boolean isUpdated() {
        return this.delivery.isUpdated();
    }

    public boolean isWritable() {
        return this.delivery.isWritable();
    }

    public int pending() {
        return this.delivery.pending();
    }

    public boolean isPartial() {
        return this.delivery.isPartial();
    }

    @Override
    public DeliveryState getRemoteState() {
        return this.delivery.getRemoteState();
    }

    @Override
    public int getMessageFormat() {
        return this.delivery.getMessageFormat();
    }

    public boolean isBuffered() {
        return this.delivery.isBuffered();
    }

    @Override
    public ProtonDelivery disposition(DeliveryState state, boolean settle) {
        if (this.delivery.isSettled()) {
            return this;
        }
        this.delivery.disposition(state);
        if (settle) {
            this.settle();
        } else {
            this.flushConnection();
        }
        return this;
    }

    @Override
    public ProtonDelivery settle() {
        this.delivery.settle();
        this.flushConnection();
        return this;
    }

    private void flushConnection() {
        this.getLinkImpl().getSession().getConnectionImpl().flush();
    }

    public ProtonDelivery handler(Handler<ProtonDelivery> handler) {
        this.handler = handler;
        if (this.delivery.isSettled()) {
            this.fireUpdate();
        }
        return this;
    }

    boolean isAutoSettle() {
        return this.autoSettle;
    }

    void setAutoSettle(boolean autoSettle) {
        this.autoSettle = autoSettle;
    }

    void fireUpdate() {
        if (this.handler != null) {
            this.handler.handle(this);
        }
        if (this.autoSettle && this.delivery.remotelySettled() && !this.delivery.isSettled()) {
            this.settle();
        }
    }

    public ProtonLinkImpl getLinkImpl() {
        return (ProtonLinkImpl)this.delivery.getLink().getContext();
    }
}

