/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.dev.config.ConfigurationProblem;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ConfigurationException
extends RuntimeException
implements ConfigurationProblem {
    private static final long serialVersionUID = 4445679764085720090L;
    private final Set<String> configKeys;

    public ConfigurationException(Set<String> configKeys) {
        this.configKeys = configKeys;
    }

    public ConfigurationException(String msg) {
        this(msg, Collections.emptySet());
    }

    public ConfigurationException(String msg, Set<String> configKeys) {
        super(msg);
        this.configKeys = configKeys;
    }

    public ConfigurationException(Throwable cause, Set<String> configKeys) {
        super(cause);
        this.configKeys = ConfigurationException.forwardCauseConfigKeys(configKeys, cause);
    }

    public ConfigurationException(String msg, Throwable cause) {
        this(msg, cause, Collections.emptySet());
    }

    public ConfigurationException(String msg, Throwable cause, Set<String> configKeys) {
        super(msg, cause);
        this.configKeys = ConfigurationException.forwardCauseConfigKeys(configKeys, cause);
    }

    public ConfigurationException(Throwable cause) {
        super(cause);
        this.configKeys = Collections.emptySet();
    }

    @Override
    public Set<String> getConfigKeys() {
        return this.configKeys;
    }

    private static Set<String> forwardCauseConfigKeys(Set<String> configKeys, Throwable cause) {
        if (cause instanceof ConfigurationProblem) {
            HashSet<String> merged = new HashSet<String>(configKeys);
            merged.addAll(((ConfigurationProblem)((Object)cause)).getConfigKeys());
        }
        return configKeys;
    }
}

