/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.image;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ImageName {
    private String repository;
    private String registry;
    private String tag;
    private String digest;
    private static final int REPO_NAME_MAX_LENGTH = 255;
    private static final String NAME_COMPONENT_REGEXP = "[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?";
    private static final String DOMAIN_COMPONENT_REGEXP = "(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])";
    private static final String IPV6_ADDRESS_REGEXP = "\\[[a-fA-F0-9:]+\\]";
    private static final Pattern NAME_COMP_REGEXP = Pattern.compile("[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?");
    private static final Pattern IMAGE_NAME_REGEXP = Pattern.compile("[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?(?:(?:/[a-z0-9]+(?:(?:(?:[._]|__|[-]*)[a-z0-9]+)+)?)+)?");
    private static final String OPTIONAL_PORT_REGEXP = "(?::[0-9]+)?";
    private static final String DOMAIN_NAME_REGEXP = "(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))*";
    private static final String REGISTRY_HOST_REGEXP = "^(?:\\[[a-fA-F0-9:]+\\]|(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))*)";
    private static final Pattern REGISTRY_REGEXP = Pattern.compile("^(?:\\[[a-fA-F0-9:]+\\]|(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))*)(?::[0-9]+)?");
    private static final Pattern TAG_REGEXP = Pattern.compile("^[\\w][\\w.-]{0,127}$");
    private static final Pattern DIGEST_256_REGEXP = Pattern.compile("sha256:([0-9a-f]{64})");
    private static final Pattern DIGEST_512_REGEXP = Pattern.compile("sha512:([0-9a-f]{128})");
    private static final Pattern DIGEST_REGEXP = Pattern.compile("^(?:" + DIGEST_256_REGEXP + "|" + DIGEST_512_REGEXP + ")");

    public ImageName(String fullName) {
        this(fullName, null);
    }

    public ImageName(String fullName, String givenTag) {
        Pattern tagPattern;
        Matcher matcher;
        if (fullName == null) {
            throw new NullPointerException("Image name must not be null");
        }
        this.digest = null;
        if (fullName.contains("@sha256") || fullName.contains("@sha512")) {
            String[] digestParts = fullName.split("@");
            this.digest = digestParts[1];
            fullName = digestParts[0];
        }
        if (!(matcher = (tagPattern = Pattern.compile("^(.+?)(?::([^:/]+))?$")).matcher(fullName)).matches()) {
            throw new IllegalArgumentException(fullName + " is not a proper image name ([registry/][repo][:port]");
        }
        this.tag = givenTag != null ? givenTag : matcher.group(2);
        String rest = matcher.group(1);
        this.parseComponentsBeforeTag(rest);
        if (this.tag == null && this.digest == null) {
            this.tag = "latest";
        }
        this.doValidate();
    }

    public String getRepository() {
        return this.repository;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getTag() {
        return this.tag;
    }

    public String getDigest() {
        return this.digest;
    }

    public boolean hasRegistry() {
        return this.registry != null && !this.registry.isEmpty();
    }

    public boolean isFullyQualifiedName() {
        if (StringUtils.isNotBlank((CharSequence)this.registry) && this.containsColon(this.registry)) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)this.registry) && StringUtils.isNotBlank((CharSequence)this.inferUser()) && StringUtils.isNotBlank((CharSequence)this.getRepository()) && (StringUtils.isNotBlank((CharSequence)this.getTag()) || StringUtils.isNotBlank((CharSequence)this.getDigest()));
    }

    private String joinTail(String[] parts) {
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < parts.length; ++i) {
            builder.append(parts[i]);
            if (i >= parts.length - 1) continue;
            builder.append("/");
        }
        return builder.toString();
    }

    private boolean containsPeriodOrColon(String part) {
        return this.containsPeriod(part) || this.containsColon(part);
    }

    private boolean containsPeriod(String part) {
        return part.contains(".");
    }

    private boolean containsColon(String part) {
        return part.contains(":");
    }

    public String getNameWithoutTag() {
        return this.getNameWithoutTag(null);
    }

    public String getNameWithoutTag(String optionalRegistry) {
        StringBuilder ret = new StringBuilder();
        if (!this.isFullyQualifiedName() && this.isRegistryValidPathComponent() && StringUtils.isNotBlank((CharSequence)optionalRegistry) && !optionalRegistry.equals(this.registry)) {
            ret.append(optionalRegistry).append("/").append(this.registry).append("/");
        } else if (this.registry != null || optionalRegistry != null) {
            ret.append(this.registry != null ? this.registry : optionalRegistry).append("/");
        }
        ret.append(this.repository);
        return ret.toString();
    }

    public String getFullName() {
        return this.getFullName(null);
    }

    public String getFullName(String optionalRegistry) {
        String fullName = this.getNameWithoutTag(optionalRegistry);
        if (this.tag != null) {
            fullName = fullName + ":" + this.tag;
        }
        if (this.digest != null) {
            fullName = fullName + "@" + this.digest;
        }
        return fullName;
    }

    public String inferUser() {
        if (StringUtils.isNotBlank((CharSequence)this.repository)) {
            if (this.repository.contains("/")) {
                return this.repository.split("/")[0];
            }
            return null;
        }
        return null;
    }

    public String getSimpleName() {
        int delimiterIndex = this.repository.indexOf(47);
        if (delimiterIndex >= 0) {
            return this.repository.substring(delimiterIndex + 1);
        }
        return this.repository;
    }

    public static void validate(String image) {
        new ImageName(image);
    }

    private void doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        String user = this.inferUser();
        String image = user != null ? this.repository.substring(user.length() + 1) : this.repository;
        Object[] checks = new Object[]{"registry", REGISTRY_REGEXP, this.registry, "image", IMAGE_NAME_REGEXP, image, "user", NAME_COMP_REGEXP, user, "tag", TAG_REGEXP, this.tag, "digest", DIGEST_REGEXP, this.digest};
        if (this.repository.length() > 255) {
            errors.add(String.format("Repository name must not be more than %d characters", 255));
        }
        for (int i = 0; i < checks.length; i += 3) {
            String value = (String)checks[i + 2];
            Pattern checkPattern = (Pattern)checks[i + 1];
            if (value == null || checkPattern.matcher(value).matches()) continue;
            errors.add(String.format("%s part '%s' doesn't match allowed pattern '%s'", checks[i], value, checkPattern.pattern()));
        }
        if (!errors.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("Given Docker name '%s' is invalid:%n", this.getFullName()));
            for (String error : errors) {
                buf.append(String.format("   * %s%n", error));
            }
            buf.append("See http://bit.ly/docker_image_fmt for more details");
            throw new IllegalArgumentException(buf.toString());
        }
    }

    private void parseComponentsBeforeTag(String rest) {
        String[] parts = rest.split("\\s*/\\s*");
        if (parts.length == 1) {
            this.registry = null;
            this.repository = parts[0];
        } else if (parts.length >= 2) {
            if (this.isValidDomain(parts[0])) {
                this.registry = parts[0];
                this.repository = this.joinTail(parts);
            } else {
                this.registry = null;
                this.repository = rest;
            }
        }
    }

    private boolean isValidDomain(String str) {
        return this.containsPeriodOrColon(str) && REGISTRY_REGEXP.matcher(str).matches();
    }

    private boolean isRegistryValidPathComponent() {
        return StringUtils.isNotBlank((CharSequence)this.registry) && !this.containsColon(this.registry);
    }
}

