/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.handlers;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.handlers.Messages;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class PerfStatsQuickDiffHandler
implements IHandler {
    public Object execute(ExecutionEvent event) {
        PerfPlugin plugin = PerfPlugin.getDefault();
        IPath curStatData = plugin.getPerfFile("perf.stat");
        IPath prevStatData = plugin.getPerfFile("perf.old.stat");
        IFile curStatFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(curStatData);
        IFile prevStatFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(prevStatData);
        IEvaluationContext ctx = (IEvaluationContext)event.getApplicationContext();
        ctx.addVariable("selection", (Object)new StructuredSelection((Object[])new IResource[]{prevStatFile, curStatFile}));
        ICommandService cmdService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command cmd = cmdService.getCommand("org.eclipse.linuxtools.perf.CompareAction");
        try {
            cmd.executeWithChecks(event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean isEnabled() {
        PerfPlugin plugin = PerfPlugin.getDefault();
        IPath workingDir = plugin.getWorkingDir();
        URI curStatDataURI = null;
        URI prevStatDataURI = null;
        if (workingDir != null) {
            IPath curStatData = plugin.getPerfFile("perf.stat");
            IPath prevStatData = plugin.getPerfFile("perf.old.stat");
            IRemoteFileProxy proxy = null;
            try {
                curStatDataURI = new URI(curStatData.toPortableString());
                prevStatDataURI = new URI(prevStatData.toPortableString());
                proxy = RemoteProxyManager.getInstance().getFileProxy(curStatDataURI);
            }
            catch (URISyntaxException e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MsgProxyError, (String)Messages.MsgProxyError);
            }
            catch (CoreException e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MsgProxyError, (String)Messages.MsgProxyError);
            }
            IFileStore curFileStore = proxy.getResource(curStatDataURI.getPath());
            IFileStore prevFileStore = proxy.getResource(prevStatDataURI.getPath());
            return curFileStore.fetchInfo().exists() && prevFileStore.fetchInfo().exists();
        }
        return false;
    }

    public boolean isHandled() {
        return this.isEnabled();
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

