/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static final <T> boolean addAll(Collection<? super T> c, Iterable<T> iterable) {
        return CollectionUtil.addAll(c, iterable.iterator());
    }

    public static final <T> boolean addAll(Collection<? super T> c, Iterator<T> iterator) {
        boolean changed = false;
        while (iterator.hasNext()) {
            changed |= c.add(iterator.next());
        }
        return changed;
    }

    @SafeVarargs
    public static final <T> boolean addAll(Collection<? super T> c, T ... elements) {
        return Collections.addAll(c, elements);
    }

    @SafeVarargs
    public static final boolean containsOneOf(Collection<?> c, Object ... objects) {
        return CollectionUtil.containsOneOf(c, Arrays.asList(objects));
    }

    public static final boolean containsOneOf(Collection<?> c, Iterable<?> objects) {
        for (Object o : objects) {
            if (!c.contains(o)) continue;
            return true;
        }
        return false;
    }
}

