/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.datastructures.weights;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.SingleWeightFunction;

public class SingleWeightFunctionInt<E>
implements SingleWeightFunction<Integer, E> {
    private final Map<E, Integer> weightMap = new HashMap<E, Integer>();
    private Integer sumNegativeWeights = 0;
    private Integer minValue = Integer.MAX_VALUE;
    private Integer maxValue = Integer.MIN_VALUE;
    private Integer maxAbsValue = 0;

    public void addWeight(E edge, Integer weight) {
        this.weightMap.put(edge, weight);
        this.sumNegativeWeights = this.sumNegativeWeights + Math.max(0, -weight.intValue());
        this.minValue = Math.min(this.minValue, weight);
        this.maxValue = Math.max(this.maxValue, weight);
        this.maxAbsValue = Math.max(this.maxAbsValue, Math.abs(weight));
    }

    @Override
    public Integer getWeight(E edge) {
        return this.weightMap.get(edge);
    }

    public Integer getSumNegWeights() {
        return this.sumNegativeWeights;
    }

    public Map<E, Integer> getWeightMap() {
        return this.weightMap;
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Integer getMaxAbsValue() {
        return this.maxAbsValue;
    }
}

