/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.di;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4jakarta.commons.JakartaDiagnosticsParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.jdt.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.core.JDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.JakartaForJavaAssert;
import org.junit.Test;

public class DependencyInjectionTest
extends BaseJakartaTest {
    protected static JDTUtils JDT_UTILS = new JDTUtils();

    @Test
    public void DependencyInjectionDiagnostics() throws Exception {
        IJavaProject javaProject = DependencyInjectionTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/di/GreetingServlet.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaDiagnosticsParams diagnosticsParams = new JakartaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(17, 27, 35, "The annotation @Inject must not define a final field.", DiagnosticSeverity.Error, "jakarta-di", "RemoveInjectOrFinal");
        d1.setData((Object)8);
        Diagnostic d2 = JakartaForJavaAssert.d(33, 25, 39, "The annotation @Inject must not define an abstract method.", DiagnosticSeverity.Error, "jakarta-di", "RemoveInjectOrAbstract");
        d2.setData((Object)9);
        Diagnostic d3 = JakartaForJavaAssert.d(26, 22, 33, "The annotation @Inject must not define a final method.", DiagnosticSeverity.Error, "jakarta-di", "RemoveInjectOrFinal");
        d3.setData((Object)9);
        Diagnostic d4 = JakartaForJavaAssert.d(43, 23, 36, "The annotation @Inject must not define a generic method.", DiagnosticSeverity.Error, "jakarta-di", "RemoveInjectForGeneric");
        d4.setData((Object)9);
        Diagnostic d5 = JakartaForJavaAssert.d(37, 23, 35, "The annotation @Inject must not define a static method.", DiagnosticSeverity.Error, "jakarta-di", "RemoveInjectOrStatic");
        d5.setData((Object)9);
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, JDT_UTILS, d1, d2, d3, d4, d5);
        JakartaJavaCodeActionParams codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d1);
        TextEdit te = JakartaForJavaAssert.te(16, 4, 17, 4, "");
        CodeAction ca = JakartaForJavaAssert.ca(uri, "Remove @Inject", d1, te);
        TextEdit te1 = JakartaForJavaAssert.te(17, 11, 17, 17, "");
        CodeAction ca1 = JakartaForJavaAssert.ca(uri, "Remove the 'final' modifier from this field", d1, te1);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, JDT_UTILS, ca, ca1);
        codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d2);
        te = JakartaForJavaAssert.te(32, 4, 33, 4, "");
        ca = JakartaForJavaAssert.ca(uri, "Remove @Inject", d2, te);
        te1 = JakartaForJavaAssert.te(33, 10, 33, 19, "");
        ca1 = JakartaForJavaAssert.ca(uri, "Remove the 'abstract' modifier from this method", d2, te1);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, JDT_UTILS, ca, ca1);
        codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d3);
        te = JakartaForJavaAssert.te(25, 4, 26, 4, "");
        ca = JakartaForJavaAssert.ca(uri, "Remove @Inject", d3, te);
        te1 = JakartaForJavaAssert.te(26, 10, 26, 16, "");
        ca1 = JakartaForJavaAssert.ca(uri, "Remove the 'final' modifier from this method", d3, te1);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, JDT_UTILS, ca, ca1);
        codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d4);
        te = JakartaForJavaAssert.te(42, 4, 43, 4, "");
        ca = JakartaForJavaAssert.ca(uri, "Remove @Inject", d4, te);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, JDT_UTILS, ca);
        codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d5);
        te = JakartaForJavaAssert.te(36, 4, 37, 4, "");
        ca = JakartaForJavaAssert.ca(uri, "Remove @Inject", d5, te);
        te1 = JakartaForJavaAssert.te(37, 10, 37, 17, "");
        ca1 = JakartaForJavaAssert.ca(uri, "Remove the 'static' modifier from this method", d5, te1);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, JDT_UTILS, ca, ca1);
    }
}

