/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.collectionextract.ExtractionUtils;
import org.eclipse.mat.internal.collectionextract.FieldArrayCollectionExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class IBM6ArrayListCollectionExtractor
extends FieldArrayCollectionExtractor {
    private String firstIndex;
    private String lastIndex;
    private String sizeField;

    public IBM6ArrayListCollectionExtractor(String firstIndex, String lastIndex, String arrayField) {
        this(firstIndex, lastIndex, arrayField, null);
    }

    public IBM6ArrayListCollectionExtractor(String firstIndex, String lastIndex, String arrayField, String sizeField) {
        super(arrayField);
        if (firstIndex == null) {
            throw new IllegalArgumentException();
        }
        if (lastIndex == null) {
            throw new IllegalArgumentException();
        }
        this.firstIndex = firstIndex;
        this.lastIndex = lastIndex;
        this.sizeField = sizeField;
    }

    @Override
    public boolean hasSize() {
        return true;
    }

    @Override
    public Integer getSize(IObject coll) throws SnapshotException {
        Integer size;
        if (this.sizeField != null && (size = (Integer)coll.resolveValue(this.sizeField)) != null) {
            return size;
        }
        Integer firstIndex = (Integer)coll.resolveValue(this.firstIndex);
        Integer lastIndex = (Integer)coll.resolveValue(this.lastIndex);
        if (lastIndex == null) {
            if (firstIndex == null) {
                IObjectArray arr = this.extractEntries(coll);
                if (arr == null) {
                    return null;
                }
                return ExtractionUtils.getNumberOfNotNullArrayElements(arr);
            }
            return null;
        }
        if (firstIndex == null || lastIndex <= 0) {
            return lastIndex;
        }
        if (lastIndex >= firstIndex) {
            return lastIndex - firstIndex;
        }
        return lastIndex - firstIndex + this.getCapacity(coll);
    }

    @Override
    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        ISnapshot snapshot = coll.getSnapshot();
        long[] referenceArray = this.extractEntries(coll).getReferenceArray();
        Integer size = this.getSize(coll);
        if (size == null) {
            return ExtractionUtils.referenceArrayToIds(snapshot, referenceArray);
        }
        ArrayInt arr = new ArrayInt(size.intValue());
        if (size > 0) {
            Object firstIdx = coll.resolveValue(this.firstIndex);
            Object lastIdx = coll.resolveValue(this.lastIndex);
            if (!(firstIdx instanceof Integer) || !(lastIdx instanceof Integer)) {
                return ExtractionUtils.referenceArrayToIds(snapshot, referenceArray);
            }
            int firstIndex = (Integer)firstIdx;
            int lastIndex = (Integer)lastIdx;
            int end = this.getCapacity(coll);
            int i = firstIndex;
            while (i < (firstIndex < lastIndex ? lastIndex : end)) {
                if (referenceArray[i] != 0L) {
                    arr.add(snapshot.mapAddressToId(referenceArray[i]));
                }
                ++i;
            }
            i = 0;
            while (i < (firstIndex < lastIndex ? 0 : lastIndex)) {
                if (referenceArray[i] != 0L) {
                    arr.add(snapshot.mapAddressToId(referenceArray[i]));
                }
                ++i;
            }
        }
        return arr.toArray();
    }
}

