/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Detail;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Rule2MiddleType;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;

public abstract class Element2MiddleProperty
implements Nameable {
    protected final @NonNull Rule2MiddleType relation2middleType;
    protected final @NonNull String nameHint;
    protected final @NonNull Class type;
    protected final boolean isRequired;
    private @Nullable Property traceProperty;

    protected Element2MiddleProperty(@NonNull Rule2MiddleType relation2middleType, @NonNull String nameHint, @NonNull Class type, boolean isRequired) {
        this.relation2middleType = relation2middleType;
        this.nameHint = nameHint;
        this.type = type;
        this.isRequired = isRequired;
    }

    protected abstract @NonNull Property createTraceProperty();

    protected @NonNull Property createMiddleProperty(@Nullable TypedModel typedModel, @NonNull String nameHint, boolean unitOpposite) {
        Type elementType;
        if (this.relation2middleType.getTransformation2TracePackage().isFrozen()) {
            throw new IllegalStateException("Creating " + nameHint + " after trace package frozen.");
        }
        Class traceClass = this.relation2middleType.getMiddleClass();
        String domainName = typedModel != null ? typedModel.getName() : null;
        String name = this.relation2middleType.getUniquePropertyName(this, nameHint);
        Property property = PivotFactory.eINSTANCE.createProperty();
        property.setName(name);
        property.setType((Type)this.type);
        property.setIsRequired(this.isRequired);
        if (this.type instanceof DataType && !((DataType)this.type).isIsSerializable()) {
            property.setIsTransient(true);
        }
        if (domainName != null) {
            Annotation domainAnnotation = PivotFactory.eINSTANCE.createAnnotation();
            domainAnnotation.setName("http://www.eclipse.org/qvt#Domains");
            Detail domainDetail = PivotFactory.eINSTANCE.createDetail();
            domainDetail.setName("referredDomain");
            domainDetail.getValues().add(domainName);
            domainAnnotation.getOwnedDetails().add(domainDetail);
            property.getOwnedAnnotations().add(domainAnnotation);
        }
        traceClass.getOwnedProperties().add(property);
        Class oppositeType = this.type;
        if (oppositeType instanceof CollectionType && (elementType = ((CollectionType)oppositeType).getElementType()) instanceof Class) {
            oppositeType = (Class)elementType;
        }
        if (!(oppositeType instanceof DataType)) {
            Property oppositeProperty = PivotFactory.eINSTANCE.createProperty();
            oppositeProperty.setName(traceClass.getName());
            oppositeProperty.setType((Type)(unitOpposite ? traceClass : this.relation2middleType.getBagOfMiddleClass()));
            oppositeProperty.setIsRequired(!unitOpposite);
            oppositeProperty.setIsImplicit(true);
            oppositeProperty.setOwningClass(oppositeType);
            property.setOpposite(oppositeProperty);
            oppositeProperty.setOpposite(property);
        }
        return property;
    }

    public @NonNull Property getTraceProperty() {
        Property traceProperty2 = this.traceProperty;
        if (traceProperty2 == null) {
            this.traceProperty = traceProperty2 = this.createTraceProperty();
        }
        return traceProperty2;
    }

    public @NonNull String getName() {
        return this.nameHint;
    }

    public @NonNull Property synthesizeTraceModel() {
        return this.getTraceProperty();
    }

    public String toString() {
        return String.valueOf(this.nameHint) + ":" + this.type + (this.isRequired ? "[1]" : "[?]");
    }
}

