/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.accessor;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.compare.ITypedElement;
import org.eclipse.emf.common.notify.AdapterFactory;

public interface IAccessorFactory {
    public boolean isFactoryFor(Object var1);

    public int getRanking();

    public void setRanking(int var1);

    public ITypedElement createLeft(AdapterFactory var1, Object var2);

    public ITypedElement createRight(AdapterFactory var1, Object var2);

    public ITypedElement createAncestor(AdapterFactory var1, Object var2);

    public static abstract class AbstractAccessorFactory
    implements IAccessorFactory {
        private int ranking;

        public int getRanking() {
            return this.ranking;
        }

        public void setRanking(int r) {
            this.ranking = r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Registry {
        public IAccessorFactory getHighestRankingFactory(Object var1);

        public Collection<IAccessorFactory> getFactories(Object var1);

        public IAccessorFactory add(IAccessorFactory var1);

        public IAccessorFactory remove(String var1);

        public void clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RegistryImpl
    implements Registry {
        private final Map<String, IAccessorFactory> map = new ConcurrentHashMap<String, IAccessorFactory>();

        @Override
        public IAccessorFactory getHighestRankingFactory(Object target) {
            Iterator factories = this.getFactories(target).iterator();
            IAccessorFactory ret = null;
            if (factories.hasNext()) {
                IAccessorFactory highestRanking = (IAccessorFactory)factories.next();
                while (factories.hasNext()) {
                    IAccessorFactory factory = (IAccessorFactory)factories.next();
                    if (factory.getRanking() <= highestRanking.getRanking()) continue;
                    highestRanking = factory;
                }
                ret = highestRanking;
            }
            return ret;
        }

        public List<IAccessorFactory> getFactories(Object target) {
            Iterable factories = Iterables.filter(this.map.values(), RegistryImpl.isFactoryFor(target));
            ArrayList ret = Lists.newArrayList();
            for (IAccessorFactory factory : factories) {
                ret.add(factory);
            }
            return ret;
        }

        static final Predicate<IAccessorFactory> isFactoryFor(final Object target) {
            return new Predicate<IAccessorFactory>(){

                public boolean apply(IAccessorFactory d) {
                    return d.isFactoryFor(target);
                }
            };
        }

        @Override
        public IAccessorFactory add(IAccessorFactory factory) {
            Preconditions.checkNotNull((Object)factory);
            return this.map.put(factory.getClass().getName(), factory);
        }

        @Override
        public IAccessorFactory remove(String className) {
            return this.map.remove(className);
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }
}

