/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.DefaultDifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.DifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelGroupProvider
implements IDifferenceGroupProvider {
    private String label;
    private boolean activeByDefault;

    @Override
    public Iterable<? extends DifferenceGroup> getGroups(Comparison comparison) {
        EList diffs = comparison.getDifferences();
        LinkedHashMap diffByEClass = Maps.newLinkedHashMap();
        for (Diff candidate : diffs) {
            EClass target;
            if (candidate instanceof ReferenceChange) {
                EObject parentMatch;
                target = ((ReferenceChange)candidate).getReference().isContainment() ? ((parentMatch = candidate.getMatch().eContainer()) instanceof Match ? this.findEClass((Match)parentMatch) : this.findEClass(candidate.getMatch())) : this.findEClass(candidate.getMatch());
            } else {
                if (!(candidate instanceof AttributeChange)) continue;
                target = this.findEClass(candidate.getMatch());
            }
            List diffsForEClass = (List)diffByEClass.get(target);
            if (diffsForEClass == null) {
                diffsForEClass = Lists.newArrayList();
                diffByEClass.put(target, diffsForEClass);
            }
            diffsForEClass.add(candidate);
        }
        ArrayList groups = Lists.newArrayList();
        for (Map.Entry entry : diffByEClass.entrySet()) {
            groups.add(new DefaultDifferenceGroup(comparison, (Iterable)entry.getValue(), (Predicate<? super Diff>)Predicates.alwaysTrue(), ((EClass)entry.getKey()).getName()));
        }
        return groups;
    }

    private EClass findEClass(Match match) {
        EClass eClass = match.getOrigin() != null ? match.getOrigin().eClass() : (match.getRight() != null ? match.getRight().eClass() : match.getLeft().eClass());
        return eClass;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean defaultSelected() {
        return this.activeByDefault;
    }

    @Override
    public void setDefaultSelected(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public boolean isEnabled(IComparisonScope scope, Comparison comparison) {
        return true;
    }
}

