/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.provider.spec;

import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.provider.AdapterFactoryUtil;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.uml2.StereotypeApplicationChange;
import org.eclipse.emf.compare.uml2.UMLDiff;
import org.eclipse.emf.compare.uml2.provider.StereotypeApplicationChangeItemProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeApplicationChangeItemProviderSpec
extends StereotypeApplicationChangeItemProvider
implements IItemStyledLabelProvider {
    public StereotypeApplicationChangeItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Collection<?> getChildren(Object object) {
        UMLDiff umlDiff = (UMLDiff)object;
        Object ret = umlDiff.getKind() == DifferenceKind.CHANGE ? umlDiff.getRefinedBy() : super.getChildren(object);
        return ret;
    }

    public boolean hasChildren(Object object) {
        return !this.getChildren(object).isEmpty();
    }

    @Override
    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    private EObject findNonNullSide(Match match) {
        EObject side = match.getLeft() != null ? match.getLeft() : (match.getRight() != null ? match.getRight() : match.getOrigin());
        return side;
    }

    @Override
    public Object getImage(Object object) {
        UMLDiff umlDiff = (UMLDiff)object;
        Stereotype stereotype = ((StereotypeApplicationChange)umlDiff).getStereotype();
        if (stereotype == null) {
            stereotype = UMLUtil.getStereotype((EObject)umlDiff.getDiscriminant());
        }
        Object image = AdapterFactoryUtil.getImage((AdapterFactory)this.getRootAdapterFactory(), (Object)stereotype);
        return image;
    }

    public Object getForeground(Object object) {
        StereotypeApplicationChange referenceChange = (StereotypeApplicationChange)object;
        switch (referenceChange.getState()) {
            case MERGED: 
            case DISCARDED: {
                return URI.createURI((String)"color://rgb/156/156/156");
            }
        }
        return super.getForeground(object);
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        String action;
        UMLDiff umlDiff = (UMLDiff)object;
        Stereotype stereotype = ((StereotypeApplicationChange)umlDiff).getStereotype();
        if (stereotype == null) {
            stereotype = UMLUtil.getStereotype((EObject)umlDiff.getDiscriminant());
        }
        ComposedStyledString stereotypeText = new ComposedStyledString();
        if (stereotype != null) {
            stereotypeText.append(String.valueOf(AdapterFactoryUtil.getText((AdapterFactory)this.getRootAdapterFactory(), (Object)stereotype)) + ' ');
        } else if (umlDiff.getDiscriminant() instanceof NamedElement) {
            stereotypeText.append("Stereotype " + ((NamedElement)umlDiff.getDiscriminant()).getName() + ' ');
        } else {
            stereotypeText.append("Stereotype ");
        }
        Match targetMatch = umlDiff.getMatch();
        EObject target = this.findNonNullSide(targetMatch);
        String targetLabel = null;
        switch (umlDiff.getKind()) {
            case ADD: {
                action = "applied";
                break;
            }
            case DELETE: {
                action = "unapplied";
                break;
            }
            case CHANGE: {
                action = "changed";
                break;
            }
            case MOVE: {
                action = "moved";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + umlDiff.getKind());
            }
        }
        if (target != null) {
            targetLabel = String.valueOf(targetLabel) + AdapterFactoryUtil.getText((AdapterFactory)this.getRootAdapterFactory(), (Object)target);
        }
        return stereotypeText.append(" [" + targetLabel + " " + action + "]", IStyledString.Style.DECORATIONS_STYLER);
    }
}

