/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.AbstractEDiffNode;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.ComparisonNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.StructureMergeViewerGrouper;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.ThreeWayComparisonGroupProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EMFCompareStructureMergeViewerContentProvider
extends AdapterFactoryContentProvider {
    private final StructureMergeViewerGrouper fViewerGrouper;
    private final StructureMergeViewerFilter fViewerFilter;
    private final CompareConfiguration configuration;

    public EMFCompareStructureMergeViewerContentProvider(AdapterFactory adapterFactory, StructureMergeViewerGrouper structureMergeViewerGrouper, StructureMergeViewerFilter structureMergeViewerFilter, CompareConfiguration configuration) {
        super(adapterFactory);
        this.fViewerGrouper = structureMergeViewerGrouper;
        this.fViewerFilter = structureMergeViewerFilter;
        this.configuration = configuration;
    }

    public Object getParent(Object element) {
        Object ret = element instanceof Adapter ? this.getAdapterFactory().adapt(super.getParent((Object)((Adapter)element).getTarget()), ICompareInput.class) : (element instanceof IDifferenceGroup ? ((IDifferenceGroup)element).getComparison() : null);
        return ret;
    }

    public final boolean hasChildren(Object element) {
        Comparison target;
        Iterable groups;
        boolean ret = element instanceof ComparisonNode ? (Iterables.isEmpty((Iterable)(groups = this.fViewerGrouper.getGroups(target = ((ComparisonNode)((Object)element)).getTarget()))) ? super.hasChildren((Object)((Adapter)element).getTarget()) : true) : (element instanceof IDifferenceGroup ? !Iterables.isEmpty((Iterable)((IDifferenceGroup)element).getDifferences()) : (element instanceof Adapter ? super.hasChildren((Object)((Adapter)element).getTarget()) : false));
        return ret;
    }

    public final Object[] getChildren(Object element) {
        Object[] ret;
        if (element instanceof ComparisonNode) {
            Comparison target = ((ComparisonNode)((Object)element)).getTarget();
            Iterable groups = this.fViewerGrouper.getGroups(target);
            if (!Iterables.isEmpty((Iterable)groups)) {
                ret = Iterables.toArray((Iterable)groups, IDifferenceGroup.class);
            } else {
                Iterable<ICompareInput> compareInputs = EMFCompareStructureMergeViewerContentProvider.adapt(super.getChildren((Object)((Adapter)element).getTarget()), this.getAdapterFactory(), ICompareInput.class);
                ret = Iterables.toArray(compareInputs, ICompareInput.class);
            }
        } else if (element instanceof IDifferenceGroup) {
            Comparison target = ((IDifferenceGroup)element).getComparison();
            Iterable<ICompareInput> compareInputs = null;
            compareInputs = this.isThreeWayComparisonGroupProviderEnabled() && "Conflicts".equals(((IDifferenceGroup)element).getName()) ? EMFCompareStructureMergeViewerContentProvider.adapt(target.getConflicts(), this.getAdapterFactory(), ICompareInput.class) : EMFCompareStructureMergeViewerContentProvider.adapt(super.getChildren((Object)target), this.getAdapterFactory(), ICompareInput.class);
            Iterable<FilteredEDiffNode> filteredCompareInputs = this.filteredEDiffNodes(Iterables.filter(compareInputs, AbstractEDiffNode.class), ((IDifferenceGroup)element).getDifferences());
            ret = Iterables.toArray(filteredCompareInputs, FilteredEDiffNode.class);
        } else if (element instanceof FilteredEDiffNode) {
            Notifier target = ((Adapter)element).getTarget();
            Iterable<Object> children = this.filteredElements(super.getChildren((Object)target), ((FilteredEDiffNode)element).getDifferences());
            Iterable<ICompareInput> compareInputs = EMFCompareStructureMergeViewerContentProvider.adapt(children, this.getAdapterFactory(), ICompareInput.class);
            Iterable<FilteredEDiffNode> filteredCompareInputs = this.filteredEDiffNodes(Iterables.filter(compareInputs, AbstractEDiffNode.class), ((FilteredEDiffNode)element).getDifferences());
            ret = Iterables.toArray(filteredCompareInputs, FilteredEDiffNode.class);
        } else if (element instanceof Adapter) {
            ArrayList children = Lists.newArrayList((Object[])super.getChildren((Object)((Adapter)element).getTarget()));
            Iterable<ICompareInput> compareInputs = EMFCompareStructureMergeViewerContentProvider.adapt(children, this.getAdapterFactory(), ICompareInput.class);
            ret = Iterables.toArray(compareInputs, ICompareInput.class);
        } else {
            ret = new Object[]{};
        }
        return ret;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    private boolean isThreeWayComparisonGroupProviderEnabled() {
        Object property = this.configuration.getProperty("org.eclipse.emf.compare.rcp.ui.SELECTED_GROUP");
        if (property == null) {
            return false;
        }
        IDifferenceGroupProvider selectedGroup = (IDifferenceGroupProvider)property;
        return selectedGroup instanceof ThreeWayComparisonGroupProvider;
    }

    static <T> Iterable<T> adapt(Iterable<?> iterable, final AdapterFactory adapterFactory, final Class<T> type) {
        Function<Object, Object> adaptFunction = new Function<Object, Object>(){

            public Object apply(Object input) {
                return adapterFactory.adapt(input, (Object)type);
            }
        };
        return Iterables.filter((Iterable)Iterables.transform(iterable, (Function)adaptFunction), type);
    }

    static <T> Iterable<T> adapt(Object[] iterable, AdapterFactory adapterFactory, Class<T> type) {
        return EMFCompareStructureMergeViewerContentProvider.adapt(Lists.newArrayList((Object[])iterable), adapterFactory, type);
    }

    private Iterable<Object> filteredElements(Object[] unfiltered, Iterable<? extends Diff> differences) {
        return this.filteredElements(Lists.newArrayList((Object[])unfiltered), differences);
    }

    private Iterable<Object> filteredElements(Iterable<Object> unfiltered, Iterable<? extends Diff> differences) {
        ImmutableList filteredDiffs = ImmutableList.copyOf((Iterable)Iterables.filter(differences, (Predicate)Predicates.not((Predicate)Predicates.or((Iterable)this.fViewerFilter.getPredicates()))));
        Predicate<Object> isPartOfTree = new Predicate<Object>((List)filteredDiffs){
            private final /* synthetic */ List val$filteredDiffs;
            {
                this.val$filteredDiffs = list;
            }

            public boolean apply(Object input) {
                return EMFCompareStructureMergeViewerContentProvider.this.isPartOfGroup(input, this.val$filteredDiffs);
            }
        };
        return Iterables.filter(unfiltered, (Predicate)isPartOfTree);
    }

    private boolean isPartOfGroup(Object object, final Iterable<? extends Diff> differences) {
        Predicate<EObject> isPartOfTree = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return Iterables.contains((Iterable)differences, (Object)input);
            }
        };
        boolean ret = false;
        if (object instanceof Match) {
            ret = Iterables.any((Iterable)((Match)object).getAllDifferences(), (Predicate)isPartOfTree);
        } else if (object instanceof Diff) {
            if (!isPartOfTree.apply((Object)((Diff)object))) {
                if (object instanceof ReferenceChange && ((ReferenceChange)object).getReference().isContainment()) {
                    Match match = ((Diff)object).getMatch().getComparison().getMatch(((ReferenceChange)object).getValue());
                    ret = match != null ? Iterables.any((Iterable)match.getAllDifferences(), (Predicate)isPartOfTree) : false;
                }
            } else {
                ret = true;
            }
        }
        return ret;
    }

    private Iterable<FilteredEDiffNode> filteredEDiffNodes(Iterable<AbstractEDiffNode> iterable, final Iterable<? extends Diff> differences) {
        Function<AbstractEDiffNode, FilteredEDiffNode> adaptFunction = new Function<AbstractEDiffNode, FilteredEDiffNode>(){

            public FilteredEDiffNode apply(AbstractEDiffNode input) {
                return new FilteredEDiffNode(input, differences);
            }
        };
        return Iterables.transform(iterable, (Function)adaptFunction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FilteredEDiffNode
    implements ICompareInput,
    Adapter {
        private AbstractEDiffNode fDelegate;
        private Iterable<? extends Diff> differences;

        public FilteredEDiffNode(AbstractEDiffNode delegate, Iterable<? extends Diff> differences) {
            this.fDelegate = delegate;
            this.differences = differences;
        }

        private AbstractEDiffNode delegate() {
            return this.fDelegate;
        }

        public Iterable<? extends Diff> getDifferences() {
            return this.differences;
        }

        public String getName() {
            return this.delegate().getName();
        }

        public Image getImage() {
            return this.delegate().getImage();
        }

        public int getKind() {
            return this.delegate().getKind();
        }

        public ITypedElement getAncestor() {
            return this.delegate().getAncestor();
        }

        public ITypedElement getLeft() {
            return this.delegate().getLeft();
        }

        public ITypedElement getRight() {
            return this.delegate().getRight();
        }

        public void addCompareInputChangeListener(ICompareInputChangeListener listener) {
            this.delegate().addCompareInputChangeListener(listener);
        }

        public void removeCompareInputChangeListener(ICompareInputChangeListener listener) {
            this.delegate().removeCompareInputChangeListener(listener);
        }

        public void copy(boolean leftToRight) {
            this.delegate().copy(leftToRight);
        }

        public void notifyChanged(Notification notification) {
            this.delegate().notifyChanged(notification);
        }

        public Notifier getTarget() {
            return this.delegate().getTarget();
        }

        public void setTarget(Notifier newTarget) {
            this.delegate().setTarget(newTarget);
        }

        public boolean isAdapterForType(Object type) {
            return this.delegate().isAdapterForType(type);
        }
    }
}

