/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.dependency;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.uml2.internal.DirectedRelationshipChange;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.dependency.data.DependencyInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AddInterfaceRealizationTest
extends AbstractUMLTest {
    private DependencyInputData input = new DependencyInputData();

    @BeforeClass
    public static void setupClass() {
        AddInterfaceRealizationTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        AddInterfaceRealizationTest.resetRegistries();
    }

    @Test
    public void testA50UseCase() throws IOException {
        Resource left = this.input.getA5Left();
        Resource right = this.input.getA5Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testA51UseCase() throws IOException {
        Resource left = this.input.getA5Left();
        Resource right = this.input.getA5Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testA50UseCase3way() throws IOException {
        Resource left = this.input.getA5Left();
        Resource right = this.input.getA5Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testA51UseCase3way() throws IOException {
        Resource left = this.input.getA5Left();
        Resource right = this.input.getA5Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
    }

    private void testAB1(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)5L, (long)differences.size());
        Predicate addInterfaceRealizationDescription = null;
        Predicate addClientInInterfaceRealizationDescription = null;
        Predicate addSupplierInInterfaceRealizationDescription = null;
        Predicate addContractInInterfaceRealizationDescription = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            addInterfaceRealizationDescription = EMFComparePredicates.removedFromReference((String)"model.Class0", (String)"interfaceRealization", (String)"model.Class0.InterfaceRealization0");
            addClientInInterfaceRealizationDescription = EMFComparePredicates.removedFromReference((String)"model.Class0.InterfaceRealization0", (String)"client", (String)"model.Class0");
            addSupplierInInterfaceRealizationDescription = EMFComparePredicates.removedFromReference((String)"model.Class0.InterfaceRealization0", (String)"supplier", (String)"model.Interface0");
            addContractInInterfaceRealizationDescription = EMFComparePredicates.changedReference((String)"model.Class0.InterfaceRealization0", (String)"contract", (String)"model.Interface0", null);
        } else {
            addInterfaceRealizationDescription = EMFComparePredicates.addedToReference((String)"model.Class0", (String)"interfaceRealization", (String)"model.Class0.InterfaceRealization0");
            addClientInInterfaceRealizationDescription = EMFComparePredicates.addedToReference((String)"model.Class0.InterfaceRealization0", (String)"client", (String)"model.Class0");
            addSupplierInInterfaceRealizationDescription = EMFComparePredicates.addedToReference((String)"model.Class0.InterfaceRealization0", (String)"supplier", (String)"model.Interface0");
            addContractInInterfaceRealizationDescription = EMFComparePredicates.changedReference((String)"model.Class0.InterfaceRealization0", (String)"contract", null, (String)"model.Interface0");
        }
        Diff addInterfaceRealization = (Diff)Iterators.find(differences.iterator(), (Predicate)addInterfaceRealizationDescription);
        Diff addClientInInterfaceRealization = (Diff)Iterators.find(differences.iterator(), (Predicate)addClientInInterfaceRealizationDescription);
        Diff addSupplierInInterfaceRealization = (Diff)Iterators.find(differences.iterator(), (Predicate)addSupplierInInterfaceRealizationDescription);
        Diff addContractInInterfaceRealization = (Diff)Iterators.find(differences.iterator(), (Predicate)addContractInInterfaceRealizationDescription);
        Assert.assertNotNull((Object)addInterfaceRealization);
        Assert.assertNotNull((Object)addClientInInterfaceRealization);
        Assert.assertNotNull((Object)addSupplierInInterfaceRealization);
        Assert.assertNotNull((Object)addContractInInterfaceRealization);
        Assert.assertEquals((long)1L, (long)AddInterfaceRealizationTest.count((List<Diff>)differences, (Predicate<Object>)Predicates.instanceOf(DirectedRelationshipChange.class)));
        Diff addUMLDependency = null;
        addUMLDependency = kind.equals((Object)AbstractUMLTest.TestKind.ADD) ? (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(DirectedRelationshipChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))) : (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(DirectedRelationshipChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        Assert.assertNotNull((Object)addUMLDependency);
        Assert.assertEquals((long)4L, (long)addUMLDependency.getRefinedBy().size());
        Assert.assertTrue((boolean)addUMLDependency.getRefinedBy().contains((Object)addInterfaceRealization));
        Assert.assertTrue((boolean)addUMLDependency.getRefinedBy().contains((Object)addClientInInterfaceRealization));
        Assert.assertTrue((boolean)addUMLDependency.getRefinedBy().contains((Object)addSupplierInInterfaceRealization));
        Assert.assertTrue((boolean)addUMLDependency.getRefinedBy().contains((Object)addContractInInterfaceRealization));
        if (kind.equals((Object)AbstractUMLTest.TestKind.ADD)) {
            Assert.assertEquals((long)1L, (long)addClientInInterfaceRealization.getRequires().size());
            Assert.assertTrue((boolean)addClientInInterfaceRealization.getRequires().contains((Object)addInterfaceRealization));
            Assert.assertEquals((long)1L, (long)addSupplierInInterfaceRealization.getRequires().size());
            Assert.assertTrue((boolean)addSupplierInInterfaceRealization.getRequires().contains((Object)addInterfaceRealization));
            Assert.assertEquals((long)1L, (long)addContractInInterfaceRealization.getRequires().size());
            Assert.assertTrue((boolean)addContractInInterfaceRealization.getRequires().contains((Object)addInterfaceRealization));
            Assert.assertEquals((long)0L, (long)addInterfaceRealization.getRequires().size());
            Assert.assertEquals((long)0L, (long)addUMLDependency.getRequires().size());
        } else {
            Assert.assertEquals((long)0L, (long)addClientInInterfaceRealization.getRequires().size());
            Assert.assertEquals((long)0L, (long)addSupplierInInterfaceRealization.getRequires().size());
            Assert.assertEquals((long)0L, (long)addContractInInterfaceRealization.getRequires().size());
            Assert.assertEquals((long)3L, (long)addInterfaceRealization.getRequires().size());
            Assert.assertTrue((boolean)addInterfaceRealization.getRequires().contains((Object)addClientInInterfaceRealization));
            Assert.assertTrue((boolean)addInterfaceRealization.getRequires().contains((Object)addSupplierInInterfaceRealization));
            Assert.assertTrue((boolean)addInterfaceRealization.getRequires().contains((Object)addContractInInterfaceRealization));
            Assert.assertEquals((long)0L, (long)addUMLDependency.getRequires().size());
        }
        Assert.assertEquals((long)0L, (long)comparison.getEquivalences().size());
        Assert.assertNull((Object)addClientInInterfaceRealization.getEquivalence());
        this.testIntersections(comparison);
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }
}

