/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DiagnosticSupport;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResourceDependencyLocalResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResolutionUtil;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceComputationScheduler;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.SynchronizedResourceSet;
import org.eclipse.emf.compare.ide.ui.internal.util.ThreadSafeProgressMonitor;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;

public class ModelResourceVisitor
implements IResourceVisitor {
    private final SynchronizedResourceSet resourceSet;
    private final ThreadSafeProgressMonitor tspm;
    private final ResourceComputationScheduler<URI> scheduler;
    private final IResourceDependencyLocalResolver resolver;
    private final DiagnosticSupport diagnostic;

    public ModelResourceVisitor(ResourceComputationScheduler<URI> scheduler, SynchronizedResourceSet resourceSet, IResourceDependencyLocalResolver resolver, DiagnosticSupport diagnostic, ThreadSafeProgressMonitor monitor) {
        this.resourceSet = resourceSet;
        this.scheduler = scheduler;
        this.resolver = resolver;
        this.diagnostic = diagnostic;
        this.tspm = monitor;
    }

    public boolean visit(IResource resource) throws CoreException {
        if (ResolutionUtil.isInterruptedOrCanceled((IProgressMonitor)this.tspm)) {
            this.scheduler.demandShutdown();
            throw new OperationCanceledException();
        }
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (ResourceUtil.hasModelType((IFile)file)) {
                URI expectedURI = ResourceUtil.createURIFor((IFile)file);
                this.resolver.demandResolve(this.resourceSet, expectedURI, this.diagnostic, this.tspm);
            }
            return false;
        }
        return true;
    }
}

