/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions.AbstractTestUITreeNodeItemProviderAdapter;
import org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions.MockMergeAction;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.internal.merge.MergeOperation;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DefaultGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeNodeItemProviderSpec;
import org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups.provider.data.ecore.a1.EcoreA1InputData;
import org.eclipse.emf.compare.tests.edit.data.ResourceScopeProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MergeActionTest
extends AbstractTestUITreeNodeItemProviderAdapter {
    private static TreeNodeItemProviderSpec itemProvider;
    private IMerger.Registry mergerRegistry;
    private TreeNode leftAdd;
    private TreeNode leftDelete;
    private TreeNode rightAdd;
    private TreeNode rightDelete;

    @Before
    public void before() throws IOException {
        super.before();
        itemProvider = (TreeNodeItemProviderSpec)this.treeItemProviderAdapterFactory.createTreeNodeAdapter();
        this.mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
        EcoreA1InputData scopeProvider = new EcoreA1InputData();
        Comparison comparison = MergeActionTest.getComparison((ResourceScopeProvider)scopeProvider);
        this.editingDomain = EMFCompareEditingDomain.create((Notifier)scopeProvider.getLeft(), (Notifier)scopeProvider.getRight(), (Notifier)scopeProvider.getOrigin());
        TreeNode ePackageMatch = MergeActionTest.getEcoreA1_EPackageMatch(comparison);
        EList ePackage_MatchChildren = ePackageMatch.getChildren();
        Iterable ePackage_MatchChildrenData = Iterables.transform((Iterable)ePackage_MatchChildren, (Function)TREE_NODE_DATA);
        Match person_Match = this.getMatchWithFeatureValue(ePackage_MatchChildrenData, "name", "Person");
        TreeNode person_Match_Node = MergeActionTest.getTreeNode((TreeNode)ePackageMatch, (EObject)person_Match);
        EList personChildren = person_Match_Node.getChildren();
        this.leftAdd = (TreeNode)((TreeNode)personChildren.get(0)).getChildren().get(0);
        this.leftDelete = (TreeNode)((TreeNode)personChildren.get(1)).getChildren().get(0);
        Match book_Match = this.getMatchWithFeatureValue(ePackage_MatchChildrenData, "name", "Book");
        TreeNode book_Match_Node = MergeActionTest.getTreeNode((TreeNode)ePackageMatch, (EObject)book_Match);
        EList bookChildren = book_Match_Node.getChildren();
        this.rightAdd = (TreeNode)((TreeNode)bookChildren.get(2)).getChildren().get(0);
        this.rightDelete = (TreeNode)((TreeNode)bookChildren.get(1)).getChildren().get(0);
    }

    @Test
    public void testAcceptLeftEditable() throws Exception {
        MergeMode accept = MergeMode.ACCEPT;
        boolean leftEditable = true;
        boolean rightEditable = false;
        TreeNode localAdd = this.leftAdd;
        TreeNode localDelete = this.leftDelete;
        TreeNode remoteAdd = this.rightAdd;
        TreeNode remoteDelete = this.rightDelete;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, false);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        Diff localAddDiff = (Diff)localAdd.getData();
        Assert.assertTrue((boolean)accept.isLeftToRight(localAddDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)accept.getMergeAction(localAddDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localAdd));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localAddDiff.getState());
        Diff localDeleteDiff = (Diff)localDelete.getData();
        Assert.assertTrue((boolean)accept.isLeftToRight(localDeleteDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)accept.getMergeAction(localDeleteDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localDelete));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localDeleteDiff.getState());
        Diff remoteAddDiff = (Diff)remoteAdd.getData();
        Assert.assertFalse((boolean)accept.isLeftToRight(remoteAddDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)accept.getMergeAction(remoteAddDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteAdd));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteAddDiff.getState());
        Diff remoteDeleteDiff = (Diff)remoteDelete.getData();
        Assert.assertFalse((boolean)accept.isLeftToRight(remoteDeleteDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)accept.getMergeAction(remoteDeleteDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteDelete));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteDeleteDiff.getState());
    }

    @Test
    public void testRejectLeftEditable() throws Exception {
        MergeMode accept = MergeMode.REJECT;
        boolean leftEditable = true;
        boolean rightEditable = false;
        TreeNode localAdd = this.leftAdd;
        TreeNode localDelete = this.leftDelete;
        TreeNode remoteAdd = this.rightAdd;
        TreeNode remoteDelete = this.rightDelete;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, false);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        Diff localAddDiff = (Diff)localAdd.getData();
        Assert.assertFalse((boolean)accept.isLeftToRight(localAddDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)accept.getMergeAction(localAddDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localAdd));
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)localAddDiff.getState());
        Diff localDeleteDiff = (Diff)localDelete.getData();
        Assert.assertFalse((boolean)accept.isLeftToRight(localDeleteDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)accept.getMergeAction(localDeleteDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localDelete));
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)localDeleteDiff.getState());
        Diff remoteAddDiff = (Diff)remoteAdd.getData();
        Assert.assertTrue((boolean)accept.isLeftToRight(remoteAddDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)accept.getMergeAction(remoteAddDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteAdd));
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)remoteAddDiff.getState());
        Diff remoteDeleteDiff = (Diff)remoteDelete.getData();
        Assert.assertTrue((boolean)accept.isLeftToRight(remoteDeleteDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)accept.getMergeAction(remoteDeleteDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteDelete));
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)remoteDeleteDiff.getState());
    }

    @Test
    public void testAcceptRightEditable() throws Exception {
        MergeMode accept = MergeMode.ACCEPT;
        boolean leftEditable = false;
        boolean rightEditable = true;
        TreeNode localAdd = this.rightAdd;
        TreeNode localDelete = this.rightDelete;
        TreeNode remoteAdd = this.leftAdd;
        TreeNode remoteDelete = this.leftDelete;
        IEMFCompareConfiguration emfCC = this.createConfiguration(false, true);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        Diff localAddDiff = (Diff)localAdd.getData();
        Assert.assertFalse((boolean)accept.isLeftToRight(localAddDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)accept.getMergeAction(localAddDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localAdd));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localAddDiff.getState());
        Diff localDeleteDiff = (Diff)localDelete.getData();
        Assert.assertFalse((boolean)accept.isLeftToRight(localDeleteDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)accept.getMergeAction(localDeleteDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localDelete));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localDeleteDiff.getState());
        Diff remoteAddDiff = (Diff)remoteAdd.getData();
        Assert.assertTrue((boolean)accept.isLeftToRight(remoteAddDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)accept.getMergeAction(remoteAddDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteAdd));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteAddDiff.getState());
        Diff remoteDeleteDiff = (Diff)remoteDelete.getData();
        Assert.assertTrue((boolean)accept.isLeftToRight(remoteDeleteDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)accept.getMergeAction(remoteDeleteDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteDelete));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteDeleteDiff.getState());
    }

    @Test
    public void testRejectRightEditable() throws Exception {
        MergeMode accept = MergeMode.REJECT;
        boolean leftEditable = false;
        boolean rightEditable = true;
        TreeNode localAdd = this.rightAdd;
        TreeNode localDelete = this.rightDelete;
        TreeNode remoteAdd = this.leftAdd;
        TreeNode remoteDelete = this.leftDelete;
        IEMFCompareConfiguration emfCC = this.createConfiguration(false, true);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        Diff localAddDiff = (Diff)localAdd.getData();
        Assert.assertTrue((boolean)accept.isLeftToRight(localAddDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)accept.getMergeAction(localAddDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localAdd));
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)localAddDiff.getState());
        Diff localDeleteDiff = (Diff)localDelete.getData();
        Assert.assertTrue((boolean)accept.isLeftToRight(localDeleteDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)accept.getMergeAction(localDeleteDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localDelete));
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)localDeleteDiff.getState());
        Diff remoteAddDiff = (Diff)remoteAdd.getData();
        Assert.assertFalse((boolean)accept.isLeftToRight(remoteAddDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)accept.getMergeAction(remoteAddDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteAdd));
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)remoteAddDiff.getState());
        Diff remoteDeleteDiff = (Diff)remoteDelete.getData();
        Assert.assertFalse((boolean)accept.isLeftToRight(remoteDeleteDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)accept.getMergeAction(remoteDeleteDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteDelete));
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)remoteDeleteDiff.getState());
    }

    private static TreeNode getEcoreA1_EPackageMatch(Comparison comparison) throws IOException {
        TreeNode treeNode = TreeFactory.eINSTANCE.createTreeNode();
        treeNode.setData((EObject)comparison);
        treeNode.eAdapters().add((Object)new DefaultGroupProvider());
        Collection children = itemProvider.getChildren((Object)treeNode);
        Iterable matches = Iterables.filter((Iterable)children, (Predicate)matchTreeNode);
        return (TreeNode)matches.iterator().next();
    }
}

