/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.examples.statements.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.examples.extlibrary.BookCategory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.query.conditions.Condition;
import org.eclipse.emf.query.conditions.ObjectInstanceCondition;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.conditions.eobjects.EObjectTypeRelationCondition;
import org.eclipse.emf.query.conditions.eobjects.structuralfeatures.EObjectAttributeValueCondition;
import org.eclipse.emf.query.conditions.eobjects.structuralfeatures.EObjectReferenceValueCondition;
import org.eclipse.emf.query.examples.statements.actions.AbstractQueryDelegate;
import org.eclipse.emf.query.examples.statements.internal.l10n.QueryStatementsMessages;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.SELECT;
import org.eclipse.emf.query.statements.WHERE;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectWritersDelegate
extends AbstractQueryDelegate {
    private static final BookCategory DEFAULT_VALUE = BookCategory.MYSTERY_LITERAL;

    public SelectWritersDelegate() {
        super(QueryStatementsMessages.selectWriters_title, QueryStatementsMessages.selectWriters_inputDialog_message, QueryStatementsMessages.selectWriters_message_notFound);
    }

    @Override
    protected Collection<EObject> performQuery(Object value) throws Exception {
        if (this.selectedEObjects == null) {
            throw new NullPointerException("Argument 'context' is null");
        }
        if (value == null) {
            throw new NullPointerException("Argument 'value' is null");
        }
        BookCategory category = (BookCategory)value;
        if (category == null) {
            throw new NullPointerException("Specified category is invalid");
        }
        EObjectReferenceValueCondition condition = new EObjectReferenceValueCondition((EObjectCondition)new EObjectTypeRelationCondition(EXTLibraryPackage.eINSTANCE.getWriter()), EXTLibraryPackage.eINSTANCE.getWriter_Books(), (EObjectCondition)new EObjectAttributeValueCondition(EXTLibraryPackage.eINSTANCE.getBook_Category(), (Condition)new ObjectInstanceCondition((Object)category)));
        SELECT statement = new SELECT(new FROM(this.selectedEObjects), new WHERE((EObjectCondition)condition));
        return statement.execute();
    }

    public void run(IAction action) {
        final List contents = BookCategory.VALUES;
        ListDialog dialog = new ListDialog(this.shell);
        dialog.setTitle(this.title);
        dialog.setInput((Object)contents);
        dialog.setInitialElementSelections(Collections.singletonList(DEFAULT_VALUE));
        dialog.setContentProvider(new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (contents != null && contents == inputElement) {
                    return contents.toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Enumerator) {
                    return ((Enumerator)element).getName();
                }
                return null;
            }
        });
        dialog.setMessage(QueryStatementsMessages.selectWriters_inputDialog_message);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            try {
                Collection<EObject> result = this.performQuery(dialog.getResult()[0]);
                if (result.isEmpty()) {
                    MessageDialog.openInformation((Shell)this.shell, (String)this.title, (String)this.notFoundMessage);
                } else {
                    this.editor.setSelectionToViewer(result);
                }
            }
            catch (Exception e) {
                MessageDialog.openInformation((Shell)this.shell, (String)this.title, (String)MESSAGE_EXCEPTION);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (action.isEnabled()) {
            for (EObject o : this.selectedEObjects) {
                if (o instanceof Library) continue;
                action.setEnabled(false);
                return;
            }
        }
    }
}

