/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.model.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.emf.validation.EMFEventType;

public class EMFEventTypeTest
extends TestCase {
    public void test_getInstance() {
        EMFEventTypeTest.assertSame((Object)EMFEventType.NULL, (Object)EMFEventType.getInstance((String)""));
        EMFEventTypeTest.assertSame((Object)EMFEventType.NULL, (Object)EMFEventType.getInstance((int)-1));
        EMFEventTypeTest.assertSame((Object)EMFEventType.ADD, (Object)EMFEventType.getInstance((String)"Add"));
        EMFEventTypeTest.assertSame((Object)EMFEventType.ADD, (Object)EMFEventType.getInstance((int)3));
        EMFEventTypeTest.assertSame((Object)EMFEventType.ADD_MANY, (Object)EMFEventType.getInstance((String)"Add Many"));
        EMFEventTypeTest.assertSame((Object)EMFEventType.ADD_MANY, (Object)EMFEventType.getInstance((int)5));
        EMFEventTypeTest.assertSame((Object)EMFEventType.MOVE, (Object)EMFEventType.getInstance((String)"Move"));
        EMFEventTypeTest.assertSame((Object)EMFEventType.MOVE, (Object)EMFEventType.getInstance((int)7));
        EMFEventTypeTest.assertSame((Object)EMFEventType.REMOVE, (Object)EMFEventType.getInstance((String)"Remove"));
        EMFEventTypeTest.assertSame((Object)EMFEventType.REMOVE, (Object)EMFEventType.getInstance((int)4));
        EMFEventTypeTest.assertSame((Object)EMFEventType.REMOVE_MANY, (Object)EMFEventType.getInstance((String)"Remove Many"));
        EMFEventTypeTest.assertSame((Object)EMFEventType.REMOVE_MANY, (Object)EMFEventType.getInstance((int)6));
        EMFEventTypeTest.assertSame((Object)EMFEventType.REMOVING_ADAPTER, (Object)EMFEventType.getInstance((String)"Removing Adapter"));
        EMFEventTypeTest.assertSame((Object)EMFEventType.REMOVING_ADAPTER, (Object)EMFEventType.getInstance((int)8));
        EMFEventTypeTest.assertSame((Object)EMFEventType.RESOLVE, (Object)EMFEventType.getInstance((String)"Resolve"));
        EMFEventTypeTest.assertSame((Object)EMFEventType.RESOLVE, (Object)EMFEventType.getInstance((int)9));
        EMFEventTypeTest.assertSame((Object)EMFEventType.SET, (Object)EMFEventType.getInstance((String)"Set"));
        EMFEventTypeTest.assertSame((Object)EMFEventType.SET, (Object)EMFEventType.getInstance((int)1));
        EMFEventTypeTest.assertSame((Object)EMFEventType.UNSET, (Object)EMFEventType.getInstance((String)"Unset"));
        EMFEventTypeTest.assertSame((Object)EMFEventType.UNSET, (Object)EMFEventType.getInstance((int)2));
    }

    public void test_getPredefinedInstances_177647() {
        List instances = EMFEventType.getPredefinedInstances();
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.NULL));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.ADD));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.ADD_MANY));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.MOVE));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.REMOVE));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.REMOVE_MANY));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.REMOVING_ADAPTER));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.RESOLVE));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.SET));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.UNSET));
    }

    public void test_getAllInstances() {
        List instances = EMFEventType.getAllInstances();
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.NULL));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.ADD));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.ADD_MANY));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.MOVE));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.REMOVE));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.REMOVE_MANY));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.REMOVING_ADAPTER));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.RESOLVE));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.SET));
        EMFEventTypeTest.assertTrue((boolean)instances.contains(EMFEventType.UNSET));
    }

    public void test_getName() {
        EMFEventTypeTest.assertEquals((String)"none", (String)EMFEventType.NULL.getName());
        EMFEventTypeTest.assertEquals((String)"Add", (String)EMFEventType.ADD.getName());
        EMFEventTypeTest.assertEquals((String)"Add Many", (String)EMFEventType.ADD_MANY.getName());
        EMFEventTypeTest.assertEquals((String)"Move", (String)EMFEventType.MOVE.getName());
        EMFEventTypeTest.assertEquals((String)"Remove", (String)EMFEventType.REMOVE.getName());
        EMFEventTypeTest.assertEquals((String)"Remove Many", (String)EMFEventType.REMOVE_MANY.getName());
        EMFEventTypeTest.assertEquals((String)"Removing Adapter", (String)EMFEventType.REMOVING_ADAPTER.getName());
        EMFEventTypeTest.assertEquals((String)"Resolve", (String)EMFEventType.RESOLVE.getName());
        EMFEventTypeTest.assertEquals((String)"Set", (String)EMFEventType.SET.getName());
        EMFEventTypeTest.assertEquals((String)"Unset", (String)EMFEventType.UNSET.getName());
    }

    public void test_isNull() {
        EMFEventTypeTest.assertTrue((boolean)EMFEventType.NULL.isNull());
        EMFEventTypeTest.assertFalse((boolean)EMFEventType.ADD.isNull());
        EMFEventTypeTest.assertFalse((boolean)EMFEventType.ADD_MANY.isNull());
        EMFEventTypeTest.assertFalse((boolean)EMFEventType.MOVE.isNull());
        EMFEventTypeTest.assertFalse((boolean)EMFEventType.REMOVE.isNull());
        EMFEventTypeTest.assertFalse((boolean)EMFEventType.REMOVE_MANY.isNull());
        EMFEventTypeTest.assertFalse((boolean)EMFEventType.REMOVING_ADAPTER.isNull());
        EMFEventTypeTest.assertFalse((boolean)EMFEventType.RESOLVE.isNull());
        EMFEventTypeTest.assertFalse((boolean)EMFEventType.SET.isNull());
        EMFEventTypeTest.assertFalse((boolean)EMFEventType.UNSET.isNull());
    }

    public void test_customEventType_177647() {
        EMFEventType specialOrder = EMFEventType.getInstance((String)"Special Order");
        EMFEventTypeTest.assertNotNull((Object)specialOrder);
        EMFEventTypeTest.assertFalse((specialOrder.toNotificationType() == EMFEventType.NULL.toNotificationType() ? 1 : 0) != 0);
        EMFEventTypeTest.assertFalse((specialOrder.toNotificationType() == EMFEventType.ADD.toNotificationType() ? 1 : 0) != 0);
        EMFEventTypeTest.assertFalse((specialOrder.toNotificationType() == EMFEventType.ADD_MANY.toNotificationType() ? 1 : 0) != 0);
        EMFEventTypeTest.assertFalse((specialOrder.toNotificationType() == EMFEventType.MOVE.toNotificationType() ? 1 : 0) != 0);
        EMFEventTypeTest.assertFalse((specialOrder.toNotificationType() == EMFEventType.REMOVE.toNotificationType() ? 1 : 0) != 0);
        EMFEventTypeTest.assertFalse((specialOrder.toNotificationType() == EMFEventType.REMOVE_MANY.toNotificationType() ? 1 : 0) != 0);
        EMFEventTypeTest.assertFalse((specialOrder.toNotificationType() == EMFEventType.REMOVING_ADAPTER.toNotificationType() ? 1 : 0) != 0);
        EMFEventTypeTest.assertFalse((specialOrder.toNotificationType() == EMFEventType.RESOLVE.toNotificationType() ? 1 : 0) != 0);
        EMFEventTypeTest.assertFalse((specialOrder.toNotificationType() == EMFEventType.SET.toNotificationType() ? 1 : 0) != 0);
        EMFEventTypeTest.assertFalse((specialOrder.toNotificationType() == EMFEventType.UNSET.toNotificationType() ? 1 : 0) != 0);
        EMFEventTypeTest.assertSame((Object)specialOrder, (Object)EMFEventType.getInstance((int)specialOrder.toNotificationType()));
        EMFEventTypeTest.assertSame((Object)specialOrder, (Object)EMFEventType.getInstance((String)specialOrder.getName()));
        EMFEventTypeTest.assertFalse((boolean)EMFEventType.getPredefinedInstances().contains(specialOrder));
        EMFEventTypeTest.assertTrue((boolean)EMFEventType.getAllInstances().contains(specialOrder));
    }

    public void test_readResolve() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObjectOutput output = null;
        ObjectInput input = null;
        try {
            try {
                output = new ObjectOutputStream(stream);
                for (EMFEventType next : EMFEventType.getAllInstances()) {
                    output.writeObject(next);
                }
                output.flush();
                input = new ObjectInputStream(new ByteArrayInputStream(stream.toByteArray()));
                for (EMFEventType next : EMFEventType.getAllInstances()) {
                    EMFEventTypeTest.assertSame((Object)next, (Object)input.readObject());
                }
            }
            catch (Exception e) {
                EMFEventTypeTest.fail((String)e.getLocalizedMessage());
                try {
                    output.close();
                    input.close();
                }
                catch (Exception e2) {
                    EMFEventTypeTest.fail((String)e2.getLocalizedMessage());
                }
            }
        }
        finally {
            try {
                output.close();
                input.close();
            }
            catch (Exception e) {
                EMFEventTypeTest.fail((String)e.getLocalizedMessage());
            }
        }
    }
}

