/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.diagram.providers.HenshinElementTypes;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinModelCleaner;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AttributeCreateCommand
extends EditElementCommand {
    private Shell shell;

    public AttributeCreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    public AttributeCreateCommand(CreateElementRequest req, Shell shell) {
        this(req);
        this.shell = shell;
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        return container;
    }

    public boolean canExecute() {
        Node node = (Node)this.getElementToEdit();
        return node.getType() != null && !this.getCandidateAttributes(node).isEmpty();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Node node = (Node)this.getElementToEdit();
        Rule rule = node.getGraph().getRule();
        List<EAttribute> attributes = this.getCandidateAttributes(node);
        EAttribute type = null;
        if (this.shell != null && attributes.size() > 1) {
            PopupMenu menu = this.getPopupMenu(attributes);
            if (!menu.show((Control)this.shell)) {
                monitor.setCanceled(true);
                return CommandResult.newCancelledCommandResult();
            }
            type = (EAttribute)menu.getResult();
        } else {
            type = attributes.get(0);
        }
        Attribute attribute = HenshinFactory.eINSTANCE.createAttribute();
        attribute.setType(type);
        Parameter param = null;
        for (Parameter p : rule.getParameters()) {
            if (p.getType() != null && p.getType() != type.getEAttributeType()) continue;
            param = p;
            break;
        }
        attribute.setValue(param != null ? param.getName() : String.valueOf(type.getDefaultValue()));
        node.getAttributes().add((Object)attribute);
        Node lhsNode = this.getLhsNode(node);
        if (lhsNode != null) {
            Node rhsNode = rule.getMappings().getImage(lhsNode, rule.getRhs());
            if (rhsNode != null) {
                this.addAttribute(rhsNode, (Attribute)EcoreUtil.copy((EObject)attribute));
            }
            for (NestedCondition ac : rule.getLhs().getNestedConditions()) {
                Node acNode = ac.getMappings().getImage(lhsNode, ac.getConclusion());
                if (acNode == null) continue;
                this.addAttribute(acNode, (Attribute)EcoreUtil.copy((EObject)attribute));
            }
        }
        HenshinModelCleaner.cleanRule((Rule)rule.getRootRule());
        this.doConfigure(attribute, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)attribute);
        return CommandResult.newOKCommandResult((Object)attribute);
    }

    protected List<EAttribute> getCandidateAttributes(Node node) {
        ArrayList<EAttribute> attrs = new ArrayList<EAttribute>();
        for (EAttribute attr : node.getType().getEAllAttributes()) {
            if (node.getAttribute(attr) != null) continue;
            attrs.add(attr);
        }
        Collections.sort(attrs, new Comparator<EAttribute>(){

            @Override
            public int compare(EAttribute a1, EAttribute a2) {
                return String.valueOf(a1.getName()).compareTo(String.valueOf(a2.getName()));
            }
        });
        return attrs;
    }

    protected PopupMenu getPopupMenu(List<EAttribute> attributes) {
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return HenshinElementTypes.getImage((IAdaptable)HenshinElementTypes.Attribute_3002);
            }

            public String getText(Object element) {
                return ((EAttribute)element).getName();
            }
        };
        return new PopupMenu(attributes, (ILabelProvider)labelProvider);
    }

    private void addAttribute(Node node, Attribute attribute) {
        Attribute old = node.getAttribute(attribute.getType());
        if (old != null) {
            node.getAttributes().set(node.getAttributes().indexOf((Object)old), (Object)attribute);
        } else {
            node.getAttributes().add((Object)attribute);
        }
    }

    public Node getLhsNode(Node node) {
        Graph lhs = node.getGraph().getRule().getLhs();
        if (node.getGraph() == lhs) {
            return node;
        }
        Node opposite = node.getActionNode();
        if (opposite.getGraph() == lhs) {
            return opposite;
        }
        return null;
    }

    protected void doConfigure(Attribute newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }
}

