/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.henshin.interpreter.ApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.Assignment;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.AssignmentImpl;
import org.eclipse.emf.henshin.interpreter.impl.BasicApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.ui.util.ParameterConfig;
import org.eclipse.emf.henshin.interpreter.util.InterpreterUtil;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class TransformOperation
extends WorkspaceModifyOperation {
    protected Unit unit;
    protected Collection<ParameterConfig> paramCfgs;
    protected URI inputUri;
    protected URI outputUri;

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit, Collection<ParameterConfig> paramCfgs) {
        this.unit = unit;
        this.paramCfgs = paramCfgs;
    }

    public void setInputURI(URI inputUri) {
        this.inputUri = inputUri;
    }

    public void setOutputURI(URI outputUri) {
        this.outputUri = outputUri;
    }

    public URI getInputUri() {
        return this.inputUri;
    }

    public URI getOutputUri() {
        return this.outputUri;
    }

    public Object getParameterValue(String parameterName) {
        ParameterConfig pCfg = this.getParameterConfiguration(parameterName);
        if (pCfg == null) {
            return null;
        }
        return pCfg.getValue();
    }

    public ParameterConfig getParameterConfiguration(String parameterName) {
        for (ParameterConfig pCfg : this.paramCfgs) {
            if (!pCfg.getName().equals(parameterName)) continue;
            return pCfg;
        }
        return null;
    }

    public Collection<ParameterConfig> getParameterConfigurations() {
        return this.paramCfgs;
    }

    protected Map<String, Object> prepareParameterValues() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (ParameterConfig paramCfg : this.paramCfgs) {
            if (paramCfg.isClear()) continue;
            result.put(paramCfg.getName(), paramCfg.getValue());
        }
        return result;
    }

    protected void execute(final IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        Resource output;
        monitor.beginTask("", 10);
        monitor.subTask("Initializing transformation...");
        Object resourceSet = this.unit.eResource() != null && this.unit.eResource().getResourceSet() != null ? this.unit.eResource().getResourceSet() : new ResourceSetImpl();
        Resource input = resourceSet.getResource(this.inputUri, true);
        AssignmentImpl assignment = new AssignmentImpl(this.unit);
        for (Map.Entry<String, Object> entry : this.prepareParameterValues().entrySet()) {
            Parameter param = this.unit.getParameter(entry.getKey());
            if (param == null) continue;
            assignment.setParameterValue(param, entry.getValue());
        }
        monitor.worked(2);
        if (monitor.isCanceled()) {
            return;
        }
        EngineImpl engine = new EngineImpl();
        BasicApplicationMonitor appMonitor = new BasicApplicationMonitor(){
            private int apps = 0;

            public boolean isCanceled() {
                return this.canceled || monitor.isCanceled();
            }

            public void notifyExecute(UnitApplication app, boolean success) {
                if (this.apps++ % 50 == 0) {
                    monitor.subTask("Applied " + app.getUnit() + (success ? "" : " (failed)") + ", " + app.getEGraph().size() + " objects");
                }
            }
        };
        try {
            if (!InterpreterUtil.applyToResource((Assignment)assignment, (Engine)engine, (Resource)input, (ApplicationMonitor)appMonitor) && !monitor.isCanceled()) {
                throw new CoreException((IStatus)new Status(2, "org.eclipse.emf.henshin.interpreter.ui", "Transformation could not be applied to given input model."));
            }
        }
        catch (Throwable t) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.henshin.interpreter.ui", "Error applying transformation", t));
        }
        monitor.worked(4);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask("Saving result...");
        if (this.inputUri.equals(this.outputUri)) {
            output = input;
        } else {
            output = resourceSet.createResource(this.outputUri);
            output.getContents().addAll((Collection)input.getContents());
        }
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("SCHEMA_LOCATION", Boolean.TRUE);
        try {
            output.save(options);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.henshin.interpreter.ui", "Error saving transformation result.", (Throwable)e));
        }
        monitor.worked(2);
        if (monitor.isCanceled()) {
            return;
        }
        if (this.outputUri.isPlatformResource()) {
            Path path = new Path(this.outputUri.toPlatformString(false));
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            if (file != null) {
                file.getParent().refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            }
        }
        monitor.subTask("Finalizing transformation...");
        monitor.done();
    }
}

