/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.henshin.interpreter.ui.HenshinInterpreterUIPlugin;
import org.eclipse.emf.henshin.interpreter.ui.util.ParameterConfig;
import org.eclipse.emf.henshin.model.ParameterKind;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ParameterEditTable {
    protected int CONTROL_OFFSET = 5;
    protected Collection<ParameterChangeListener> listeners = new ArrayList<ParameterChangeListener>();
    protected TableViewer tableViewer;
    protected Group container;

    public ParameterEditTable(Composite parent) {
        this.container = new Group(parent, 0);
        this.container.setText(HenshinInterpreterUIPlugin.LL("_UI_Parameters"));
        this.container.setLayout((Layout)new FormLayout());
        this.tableViewer = new TableViewer((Composite)this.container, 67584);
        FormData data = new FormData();
        data.top = new FormAttachment(0, this.CONTROL_OFFSET);
        data.left = new FormAttachment(0, this.CONTROL_OFFSET);
        data.right = new FormAttachment(100, -this.CONTROL_OFFSET);
        data.bottom = new FormAttachment(100, -this.CONTROL_OFFSET);
        data.height = 80;
        this.tableViewer.getTable().setLayoutData((Object)data);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.buildColumns();
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                Collection paramCfgs = (Collection)inputElement;
                Iterator it = paramCfgs.iterator();
                while (it.hasNext()) {
                    ParameterConfig paramCfg = (ParameterConfig)it.next();
                    if (paramCfg.getKind() != ParameterKind.VAR && paramCfg.getKind() != ParameterKind.OUT) continue;
                    it.remove();
                }
                return paramCfgs.toArray();
            }

            public void dispose() {
            }
        });
    }

    public Control getControl() {
        return this.container;
    }

    protected void buildColumns() {
        TableViewerColumn keyColumn = new TableViewerColumn(this.tableViewer, 0);
        keyColumn.getColumn().setText(HenshinInterpreterUIPlugin.LL("_UI_ParameterColumn_Name"));
        keyColumn.getColumn().setWidth(100);
        keyColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object entry) {
                return ((ParameterConfig)entry).getName();
            }
        });
        TableViewerColumn typeColumn = new TableViewerColumn(this.tableViewer, 0);
        typeColumn.getColumn().setText(HenshinInterpreterUIPlugin.LL("_UI_ParameterColumn_Type"));
        typeColumn.getColumn().setWidth(100);
        typeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ParameterConfig paramCfg = (ParameterConfig)element;
                return paramCfg.getTypeLabel();
            }
        });
        typeColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                ParameterConfig paramCfg = (ParameterConfig)element;
                paramCfg.setType((Integer)value);
                for (ParameterChangeListener l : ParameterEditTable.this.listeners) {
                    l.parameterChanged(paramCfg);
                }
                ParameterEditTable.this.tableViewer.refresh();
            }

            protected Object getValue(Object element) {
                ParameterConfig paramCfg = (ParameterConfig)element;
                return paramCfg.getType();
            }

            protected CellEditor getCellEditor(Object element) {
                return new ComboBoxCellEditor((Composite)ParameterEditTable.this.tableViewer.getTable(), ParameterConfig.getSupportedTypes().values().toArray(new String[0]), 8);
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TableViewerColumn valueColumn = new TableViewerColumn(this.tableViewer, 0);
        valueColumn.getColumn().setText(HenshinInterpreterUIPlugin.LL("_UI_ParameterColumn_Value"));
        valueColumn.getColumn().setWidth(100);
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ParameterConfig paramCfg = (ParameterConfig)element;
                switch (paramCfg.getType()) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return "null";
                    }
                    case 2: {
                        return "\"" + paramCfg.getValue() + "\"";
                    }
                }
                return "" + paramCfg.getValue();
            }
        });
        valueColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                ParameterConfig paramCfg = (ParameterConfig)element;
                try {
                    switch (paramCfg.getType()) {
                        case 2: {
                            if (!value.toString().trim().equals("") || value.toString().trim().equals("null")) {
                                paramCfg.setValue(value.toString());
                            } else {
                                paramCfg.setValue(null);
                            }
                        }
                        case 5: {
                            if (!value.toString().trim().equals("") || value.toString().trim().equals("null")) {
                                paramCfg.setValue(Float.valueOf(Float.parseFloat(value.toString())));
                            } else {
                                paramCfg.setValue(null);
                            }
                        }
                        case 7: {
                            if (!value.toString().trim().equals("") || value.toString().trim().equals("null")) {
                                paramCfg.setValue(Double.parseDouble(value.toString()));
                                break;
                            }
                            paramCfg.setValue(null);
                            break;
                        }
                        case 4: {
                            if (!value.toString().trim().equals("") || value.toString().trim().equals("null")) {
                                paramCfg.setValue(Integer.parseInt(value.toString()));
                                break;
                            }
                            paramCfg.setValue(null);
                            break;
                        }
                        case 6: {
                            if (!value.toString().trim().equals("") || value.toString().trim().equals("null")) {
                                paramCfg.setValue(Long.parseLong(value.toString()));
                                break;
                            }
                            paramCfg.setValue(null);
                            break;
                        }
                        case 3: {
                            if (!value.toString().trim().equals("") || value.toString().trim().equals("null")) {
                                paramCfg.setValue((Integer)value > 0);
                                break;
                            }
                            paramCfg.setValue(null);
                            break;
                        }
                        default: {
                            if (!value.toString().trim().equals("") || value.toString().trim().equals("null")) {
                                paramCfg.setValue(value);
                                break;
                            }
                            paramCfg.setValue(null);
                        }
                    }
                    for (ParameterChangeListener l : ParameterEditTable.this.listeners) {
                        l.parameterChanged(paramCfg);
                    }
                    ParameterEditTable.this.tableViewer.refresh();
                }
                catch (Exception exception) {}
            }

            protected Object getValue(Object entry) {
                ParameterConfig paramCfg = (ParameterConfig)entry;
                switch (paramCfg.getType()) {
                    case 3: {
                        boolean value = (Boolean)paramCfg.getValue();
                        return value ? 1 : 0;
                    }
                }
                return "" + paramCfg.getValue();
            }

            protected CellEditor getCellEditor(Object element) {
                ParameterConfig paramCfg = (ParameterConfig)element;
                switch (paramCfg.getType()) {
                    case 3: {
                        return new ComboBoxCellEditor((Composite)ParameterEditTable.this.tableViewer.getTable(), new String[]{"false", "true"}, 8);
                    }
                }
                return new TextCellEditor((Composite)ParameterEditTable.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                ParameterConfig paramCfg = (ParameterConfig)element;
                return paramCfg.getType() != 1 && paramCfg.getType() != 0;
            }
        });
    }

    public void addParameterChangeListener(ParameterChangeListener listener) {
        this.listeners.add(listener);
    }

    public void setParameters(Collection<ParameterConfig> paramCfgs) {
        this.tableViewer.setInput(paramCfgs);
    }

    public static interface ParameterChangeListener {
        public void parameterChanged(ParameterConfig var1);
    }
}

