/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.cadp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpacePlugin;
import org.eclipse.emf.henshin.statespace.ValidationResult;
import org.eclipse.emf.henshin.statespace.external.AbstractFileBasedValidator;
import org.eclipse.emf.henshin.statespace.util.StateSpaceSearch;

public class CADPStateSpaceValidator
extends AbstractFileBasedValidator {
    public static final String VALIDATOR_ID = "org.eclipse.emf.henshin.statespace.validator.cadp";

    public static void register() {
        StateSpacePlugin.INSTANCE.getValidators().put(VALIDATOR_ID, new CADPStateSpaceValidator());
    }

    public ValidationResult validate(StateSpace stateSpace, IProgressMonitor monitor) throws Exception {
        String line;
        String[] command;
        monitor.beginTask("Validating property...", 10);
        String basename = stateSpace.eResource().getURI().trimFileExtension().lastSegment();
        File cadpBin = CADPStateSpaceValidator.getCADPBin();
        String suffix = this.isWindows() ? ".exe" : "";
        File aut = this.exportAsAUT(stateSpace, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
        if (monitor.isCanceled()) {
            return null;
        }
        File bcg = File.createTempFile(basename, ".bcg");
        this.convertFile(aut, bcg, (IProgressMonitor)new SubProgressMonitor(monitor, 2), String.valueOf(cadpBin.getAbsolutePath()) + File.separator + "bcg_io" + suffix);
        if (monitor.isCanceled()) {
            return null;
        }
        File mcl = this.createTempFile("property", ".mcl", this.property);
        monitor.worked(1);
        File diag = File.createTempFile(basename, ".bcg");
        String mclAbs = mcl.getAbsolutePath();
        String bcgAbs = bcg.getAbsolutePath();
        if (this.isWindows()) {
            if (mclAbs.charAt(1) == ':') {
                mclAbs = mclAbs.substring(2);
            }
            if (bcgAbs.charAt(1) == ':') {
                bcgAbs = bcgAbs.substring(2);
            }
            mclAbs = mclAbs.replace('\\', '/');
            bcgAbs = bcgAbs.replace('\\', '/');
            command = new String[]{String.valueOf(cadpBin.getAbsolutePath()) + File.separator + "evaluator" + suffix, "-diag", diag.getAbsolutePath(), mclAbs, bcgAbs};
        } else {
            command = new String[]{String.valueOf(cadpBin.getParent()) + File.separator + "com" + File.separator + "bcg_open" + suffix, bcgAbs, "evaluator", "-diag", diag.getAbsolutePath(), mclAbs};
        }
        monitor.subTask("Running evaluator...");
        Process process = Runtime.getRuntime().exec(command);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        Boolean result = null;
        boolean parsePath = false;
        ArrayList<String> path = new ArrayList<String>();
        monitor.worked(1);
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            System.out.println(line);
            if (line.length() == 0) continue;
            if (parsePath) {
                if (line.indexOf("<goal state>") >= 0) {
                    parsePath = false;
                } else {
                    path.add(line.startsWith("\"") ? line.substring(1, line.length() - 1) : line);
                }
            } else if ("TRUE".equals(line)) {
                result = Boolean.TRUE;
            } else if ("FALSE".equals(line)) {
                result = Boolean.FALSE;
            } else if (line.indexOf("<initial state>") >= 0) {
                parsePath = true;
            }
            if (!monitor.isCanceled()) continue;
            process.destroy();
            return null;
        }
        monitor.worked(1);
        bcg.delete();
        mcl.delete();
        diag.delete();
        monitor.worked(1);
        monitor.done();
        if (result == Boolean.TRUE) {
            return ValidationResult.VALID;
        }
        if (result == Boolean.FALSE) {
            if (!path.isEmpty()) {
                return new ValidationResult(false, "Property not satisfied. See the explorer for a counterexample.", (Object)StateSpaceSearch.findPath((StateSpace)stateSpace, path));
            }
            return ValidationResult.INVALID;
        }
        throw new RuntimeException("CADP evaluator produced unexpected output.");
    }

    public static File getCADPBin() throws FileNotFoundException {
        String path = System.getenv("CADP");
        if (path == null) {
            throw new FileNotFoundException("CADP environment variable not set.");
        }
        File cadp = new File(path);
        if (!cadp.isDirectory()) {
            throw new FileNotFoundException("CADP home not found. Check the CADP environment variable.");
        }
        File[] bin = cadp.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("bin");
            }
        });
        if (bin.length == 0) {
            throw new FileNotFoundException("Cannot find 'bin' directory in CADP home.");
        }
        return bin[0];
    }

    public String getName() {
        return "CADP";
    }

    public boolean usesProperty() {
        return true;
    }
}

