/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.clustering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mergeSuggestion.MergeNAC;
import mergeSuggestion.MergePAC;
import mergeSuggestion.MergeRule;
import mergeSuggestion.MergeRuleElement;
import mergeSuggestion.MergeSuggestion;
import mergeSuggestion.impl.MergeSuggestionFactoryImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.mergein.clone.CloneGroup;

public class BasicMergeSuggestionBuilder {
    static BasicMergeSuggestionBuilder instance = new BasicMergeSuggestionBuilder();

    public static BasicMergeSuggestionBuilder getInstance() {
        return instance;
    }

    public MergeSuggestion createFromBasisClones(Collection<CloneGroup> basisClones) {
        MergeSuggestion result = MergeSuggestionFactoryImpl.eINSTANCE.createMergeSuggestion();
        for (CloneGroup cg : basisClones) {
            MergeRule rule = this.createFromBasisCloneGroup(cg);
            result.getMergeClusters().add((Object)rule);
        }
        return result;
    }

    public MergeRule createFromBasisCloneGroup(CloneGroup cg) {
        MergeRule result = MergeSuggestionFactoryImpl.eINSTANCE.createMergeRule();
        Rule masterRule = cg.getRules().iterator().next();
        result.setMasterRule(masterRule);
        this.addGraphElementsToResult(this.getAllLhs(cg.getRules()), result, cg);
        this.addGraphElementsToResult(this.getAllRhs(cg.getRules()), result, cg);
        this.addACsToResult(cg.getRules(), result, cg, true);
        this.addACsToResult(cg.getRules(), result, cg, false);
        result.getRules().addAll(cg.getRules());
        return result;
    }

    private void addACsToResult(List<Rule> rules, MergeRule result, CloneGroup cg, boolean nacs) {
        HashSet<NestedCondition> considered = new HashSet<NestedCondition>();
        for (Rule rule : rules) {
            EList acs = nacs ? rule.getLhs().getNACs() : rule.getLhs().getPACs();
            for (NestedCondition ac1 : acs) {
                if (considered.contains(ac1)) continue;
                this.addAcToResult(ac1, rule, cg, rules, result, considered, nacs);
            }
        }
    }

    private void addAcToResult(NestedCondition ac1, Rule rule1, CloneGroup cg, List<Rule> allRules, MergeRule result, Set<NestedCondition> considered, boolean nacs) {
        HashSet<NestedCondition> corresponding = new HashSet<NestedCondition>();
        corresponding.add(ac1);
        block0: for (Rule rule2 : allRules) {
            EList acs = nacs ? rule2.getLhs().getNACs() : rule2.getLhs().getPACs();
            for (NestedCondition ac2 : acs) {
                if (rule1 == rule2 || ac1 == ac2 || considered.contains(ac2) || !this.isFullClone(ac1, ac2, cg)) continue;
                corresponding.add(ac2);
                continue block0;
            }
        }
        if (corresponding.size() < allRules.size()) {
            this.addAcsToMergeResult(result, corresponding, true, nacs);
        } else if (corresponding.size() == allRules.size()) {
            this.addAcsToMergeResult(result, corresponding, false, nacs);
        } else {
            throw new RuntimeException("Error during adding of NACs/PACs.");
        }
        considered.addAll(corresponding);
    }

    private void addAcsToMergeResult(MergeRule result, Set<NestedCondition> corresponding, boolean isolated, boolean nacs) {
        if (nacs && isolated) {
            for (NestedCondition nac : corresponding) {
                MergeNAC el = MergeSuggestionFactoryImpl.eINSTANCE.createMergeNAC();
                el.getReferenceNACs().add((Object)nac.getConclusion());
                result.addMergeNAC(el);
            }
        } else if (nacs && !isolated) {
            MergeNAC el = MergeSuggestionFactoryImpl.eINSTANCE.createMergeNAC();
            for (NestedCondition nac : corresponding) {
                el.getReferenceNACs().add((Object)nac.getConclusion());
            }
            result.addMergeNAC(el);
        } else if (!nacs && isolated) {
            for (NestedCondition nac : corresponding) {
                MergePAC el = MergeSuggestionFactoryImpl.eINSTANCE.createMergePAC();
                el.getReferencePACs().add((Object)nac.getConclusion());
                result.addMergePAC(el);
            }
        } else if (!nacs && !isolated) {
            MergePAC el = MergeSuggestionFactoryImpl.eINSTANCE.createMergePAC();
            for (NestedCondition nac : corresponding) {
                el.getReferencePACs().add((Object)nac.getConclusion());
            }
            result.addMergePAC(el);
        }
    }

    private boolean isFullClone(NestedCondition ac1, NestedCondition ac2, CloneGroup cg) {
        return this.isFullyContained(ac1.getConclusion(), ac2.getConclusion(), cg) && this.isFullyContained(ac2.getConclusion(), ac1.getConclusion(), cg);
    }

    private boolean isFullyContained(Graph acGraph, Graph acGraph2, CloneGroup cg) {
        for (Node node : acGraph.getNodes()) {
            if (this.isSpecificForApplicationCondition((GraphElement)node) && !this.nodeHasCounterpart(node, acGraph2, cg)) {
                return false;
            }
            for (Attribute attribute : node.getAttributes()) {
                if (!this.isSpecificForApplicationCondition((GraphElement)attribute) || this.attributeHasCounterpart(attribute, acGraph2, cg)) continue;
                return false;
            }
        }
        for (Edge edge : acGraph.getEdges()) {
            if (!this.isSpecificForApplicationCondition((GraphElement)edge) || this.edgeHasCounterpart(edge, acGraph2, cg) && this.nodeHasCounterpart(edge.getSource(), acGraph2, cg) && this.nodeHasCounterpart(edge.getTarget(), acGraph2, cg)) continue;
            return false;
        }
        return true;
    }

    private boolean nodeHasCounterpart(Node node, Graph acGraph2, CloneGroup cg) {
        Map<Rule, Node> mapping = cg.getNodeMappings().get(node.getActionNode());
        return mapping != null && mapping.get(acGraph2.getRule()) != null;
    }

    private boolean attributeHasCounterpart(Attribute attribute, Graph acGraph2, CloneGroup cg) {
        Map<Rule, Attribute> mapping = cg.getAttributeMappings().get(attribute.getActionAttribute());
        return mapping != null && mapping.get(acGraph2.getRule()) != null;
    }

    private boolean edgeHasCounterpart(Edge edge, Graph acGraph2, CloneGroup cg) {
        Map<Rule, Edge> mapping = cg.getEdgeMappings().get(edge.getActionEdge());
        return mapping != null && mapping.get(acGraph2.getRule()) != null;
    }

    private boolean isSpecificForApplicationCondition(GraphElement graphElement) {
        return graphElement.getAction() != null && (graphElement.getAction().getType() == Action.Type.FORBID || graphElement.getAction().getType() == Action.Type.REQUIRE);
    }

    protected void addGraphElementsToResult(List<Graph> graphs, MergeRule result, CloneGroup cloneGroup) {
        HashSet<GraphElement> addedElements = new HashSet<GraphElement>();
        for (Graph graph : graphs) {
            for (GraphElement ge : this.getGraphElements(graph)) {
                if (graph.isNestedCondition()) continue;
                this.addGraphElementToResult(ge, graphs, result, cloneGroup, addedElements);
            }
        }
    }

    protected void addApplicationConditionToResult(List<Graph> graphs, MergeRule result, CloneGroup cloneGroup) {
    }

    protected void addGraphElementToResult(GraphElement ge, List<Graph> correspondingGraphs, MergeRule result, CloneGroup cloneGroup, Set<GraphElement> addedElements) {
        if (!addedElements.contains(ge)) {
            if (this.isCloneElement(ge, cloneGroup)) {
                this.addCloneMergeElementToResult(ge, correspondingGraphs, result, addedElements, cloneGroup);
            } else {
                this.addSingleElementToResult(result, ge);
                addedElements.add(ge);
            }
        }
    }

    protected List<Graph> getAllLhs(List<Rule> list) {
        ArrayList<Graph> result = new ArrayList<Graph>();
        for (Rule rule : list) {
            result.add(rule.getLhs());
        }
        return result;
    }

    protected List<Graph> getAllRhs(List<Rule> list) {
        ArrayList<Graph> result = new ArrayList<Graph>();
        for (Rule rule : list) {
            result.add(rule.getRhs());
        }
        return result;
    }

    protected List<Graph> getAllMultiLhs(List<Rule> list) {
        ArrayList<Graph> result = new ArrayList<Graph>();
        for (Rule rule : list) {
            for (Rule multiRule : rule.getMultiRules()) {
                result.add(multiRule.getLhs());
            }
        }
        return result;
    }

    protected List<Graph> getAllMultiRhs(List<Rule> list) {
        ArrayList<Graph> result = new ArrayList<Graph>();
        for (Rule rule : list) {
            for (Rule multiRule : rule.getMultiRules()) {
                result.add(multiRule.getRhs());
            }
        }
        return result;
    }

    protected List<Graph> getPacs(List<Rule> list) {
        ArrayList<Graph> result = new ArrayList<Graph>();
        for (Rule rule : list) {
            for (NestedCondition nac : rule.getLhs().getPACs()) {
                result.add(nac.getConclusion());
            }
        }
        return result;
    }

    protected boolean isCloneElement(GraphElement element, CloneGroup cg) {
        GraphElement actionElement = this.getActionElement(element);
        if (actionElement instanceof Edge) {
            return cg.getEdgeMappings().keySet().contains(actionElement);
        }
        if (actionElement instanceof Attribute) {
            return cg.getAttributeMappings().keySet().contains(actionElement);
        }
        if (actionElement instanceof Node) {
            return cg.getNodeMappings().keySet().contains(actionElement);
        }
        return false;
    }

    protected List<GraphElement> getAllGraphElements(Rule r) {
        ArrayList<GraphElement> result = new ArrayList<GraphElement>();
        TreeIterator it = r.eAllContents();
        while (it.hasNext()) {
            EObject e = (EObject)it.next();
            if (!(e instanceof GraphElement)) continue;
            result.add((GraphElement)e);
        }
        return result;
    }

    protected GraphElement getActionElement(GraphElement element) {
        if (element instanceof Node) {
            return ((Node)element).getActionNode();
        }
        if (element instanceof Attribute) {
            return ((Attribute)element).getActionAttribute();
        }
        if (element instanceof Edge) {
            return ((Edge)element).getActionEdge();
        }
        return null;
    }

    protected void addCloneMergeElementToResult(GraphElement graphElement, List<Graph> graphs, MergeRule result, Set<GraphElement> addedElements, CloneGroup cloneGroup) {
        MergeRuleElement merged = this.addSingleElementToResult(result, graphElement);
        addedElements.add(graphElement);
        for (Graph graph : graphs) {
            GraphElement clone = this.findClone(graphElement, graph, cloneGroup);
            if (clone == null) continue;
            merged.getReferenceElements().add((Object)clone);
            addedElements.add(clone);
        }
    }

    protected GraphElement findClone(GraphElement ge, Graph graph, CloneGroup cloneGroup) {
        Map<Rule, Node> innerMap;
        GraphElement actionElement2;
        Map<Node, Map<Rule, Node>> outerMap = null;
        if (ge instanceof Node) {
            outerMap = cloneGroup.getNodeMappings();
        } else if (ge instanceof Edge) {
            outerMap = cloneGroup.getEdgeMappings();
        } else if (ge instanceof Attribute) {
            outerMap = cloneGroup.getAttributeMappings();
        }
        Rule rule = this.getRule(graph);
        GraphElement actionElement = this.getActionElement(ge);
        if (outerMap != null && rule != null && actionElement != null && (actionElement2 = (GraphElement)(innerMap = outerMap.get(actionElement)).get(rule)) != null) {
            for (GraphElement ge2 : this.getGraphElements(graph)) {
                if (this.getActionElement(ge2) != actionElement2) continue;
                return ge2;
            }
        }
        return null;
    }

    protected Rule getRule(Graph graph) {
        EObject container = graph.eContainer();
        while (container.eContainer() != null) {
            if (container instanceof Rule) {
                return (Rule)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    protected MergeRuleElement addSingleElementToResult(MergeRule result, GraphElement ge) {
        MergeRuleElement el = MergeSuggestionFactoryImpl.eINSTANCE.createMergeRuleElement();
        el.getReferenceElements().add((Object)ge);
        result.addMergeRuleElement(el);
        return el;
    }

    private List<GraphElement> getGraphElements(Graph graph) {
        ArrayList<GraphElement> result = new ArrayList<GraphElement>();
        result.addAll((Collection<GraphElement>)graph.getNodes());
        result.addAll((Collection<GraphElement>)graph.getEdges());
        for (Node n : graph.getNodes()) {
            result.addAll((Collection<GraphElement>)n.getAttributes());
        }
        return result;
    }
}

