/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability;

import java.util.Set;
import org.eclipse.emf.henshin.interpreter.ApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.Assignment;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.MatchImpl;
import org.eclipse.emf.henshin.interpreter.impl.RuleApplicationImpl;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.InconsistentRuleException;
import org.eclipse.emf.henshin.variability.MatchingLog;
import org.eclipse.emf.henshin.variability.MatchingLogEntry;
import org.eclipse.emf.henshin.variability.matcher.VariabilityAwareEngine;
import org.eclipse.emf.henshin.variability.matcher.VariabilityAwareMatch;
import org.eclipse.emf.henshin.variability.util.RuleUtil;

public class VarRuleApplicationImpl
extends RuleApplicationImpl {
    VariabilityAwareMatch completeVarMatch;

    public VarRuleApplicationImpl(Engine engine, EGraph graph, Rule rule, Assignment partialMatch) {
        super(engine, graph, rule, partialMatch);
    }

    public VarRuleApplicationImpl(Engine engine, EGraph graph, Rule rule, VariabilityAwareMatch completeMatchVar) {
        super(engine, graph, rule, null);
        this.completeVarMatch = completeMatchVar;
    }

    public VarRuleApplicationImpl(Engine engine) {
        super(engine);
    }

    public boolean execute(ApplicationMonitor monitor) {
        if (this.unit == null) {
            throw new NullPointerException("No transformation unit set");
        }
        if (this.isExecuted) {
            if (this.isCompleteMatchDerived) {
                this.completeMatch = null;
                this.isCompleteMatchDerived = false;
            }
            this.isExecuted = false;
            this.isUndone = false;
            this.change = null;
            this.resultMatch = null;
        }
        if (this.completeVarMatch != null) {
            this.completeMatch = this.completeVarMatch.getMatch();
        } else {
            long startTime = System.currentTimeMillis();
            if (this.completeMatch == null) {
                if (!RuleUtil.isVarRule(this.unit)) {
                    this.completeMatch = (Match)this.engine.findMatches((Rule)this.unit, this.graph, this.partialMatch).iterator().next();
                } else {
                    VariabilityAwareEngine vbEngine;
                    try {
                        vbEngine = new VariabilityAwareEngine((Rule)this.unit, this.graph);
                    }
                    catch (InconsistentRuleException inconsistentRuleException) {
                        return false;
                    }
                    Set<VariabilityAwareMatch> matches = vbEngine.findMatches();
                    if (!matches.isEmpty()) {
                        this.completeVarMatch = matches.iterator().next();
                        this.completeMatch = this.completeVarMatch.getMatch();
                        this.unit = this.completeVarMatch.getMatch().getRule();
                    }
                }
                this.isCompleteMatchDerived = true;
            }
            long runtime = System.currentTimeMillis() - startTime;
            MatchingLog.getEntries().add(new MatchingLogEntry(this.unit, this.completeMatch != null, runtime, this.graph.size(), 0));
            if (this.completeMatch == null) {
                if (monitor != null) {
                    monitor.notifyExecute((UnitApplication)this, false);
                }
                return false;
            }
        }
        if (this.completeVarMatch != null) {
            this.completeVarMatch.prepareRule();
        }
        this.resultMatch = new MatchImpl((Rule)this.unit, true);
        this.change = this.engine.createChange((Rule)this.unit, this.graph, this.completeMatch, this.resultMatch);
        if (this.change == null) {
            if (monitor != null) {
                monitor.notifyExecute((UnitApplication)this, false);
            }
            return false;
        }
        this.change.applyAndReverse();
        this.isExecuted = true;
        if (monitor != null) {
            monitor.notifyExecute((UnitApplication)this, true);
        }
        if (this.completeVarMatch != null) {
            this.completeVarMatch.undoPreparation();
        }
        return true;
    }
}

