/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.util;

import aima.core.logic.propositional.parsing.ast.Sentence;
import aima.core.logic.propositional.visitors.SymbolCollector;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.variability.matcher.FeatureExpression;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityFactory;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityRule;

public class RuleUtil {
    public static void removeElementsFromRule(Rule rule, List<GraphElement> elementsToRemove) {
        HashSet<Node> nodes2delete = new HashSet<Node>();
        HashSet<Edge> edges2delete = new HashSet<Edge>();
        HashSet<Attribute> attribs2delete = new HashSet<Attribute>();
        for (GraphElement o : elementsToRemove) {
            if (o instanceof Node) {
                Node n = (Node)o;
                nodes2delete.add(n);
                edges2delete.addAll((Collection<Edge>)n.getIncoming());
                edges2delete.addAll((Collection<Edge>)n.getOutgoing());
                continue;
            }
            if (o instanceof Edge) {
                edges2delete.add((Edge)o);
                continue;
            }
            if (!(o instanceof Attribute)) continue;
            attribs2delete.add((Attribute)o);
        }
        for (Attribute a : attribs2delete) {
            rule.removeAttribute(a, true);
        }
        for (Edge e : edges2delete) {
            rule.removeEdge(e, true);
        }
        for (Node n : nodes2delete) {
            rule.removeNode(n, true);
        }
    }

    public static boolean isVarRule(Unit unit) {
        return unit instanceof Rule && VariabilityFactory.createVariabilityRule((Rule)unit).getFeatureModel() != null;
    }

    public static boolean checkRule(Rule rule) {
        if (!RuleUtil.isVarRule((Unit)rule)) {
            return true;
        }
        VariabilityRule varRule = VariabilityFactory.createVariabilityRule(rule);
        List<String> features = varRule.getFeatures();
        Stream fm = SymbolCollector.getSymbolsFrom((Sentence[])new Sentence[]{FeatureExpression.getExpr(varRule.getFeatureModel())}).parallelStream();
        Stream symbols = varRule.getAnnotations().parallelStream().filter(annot -> "presenceCondition".equals(annot.getKey())).flatMap(annot -> SymbolCollector.getSymbolsFrom((Sentence[])new Sentence[]{FeatureExpression.getExpr(annot.getValue())}).parallelStream());
        List symbolNames = Stream.concat(fm, symbols).map(symbol -> symbol.getSymbol()).distinct().collect(Collectors.toList());
        return features.containsAll(symbolNames);
    }
}

