/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.interpreter.ui.debug.ParamUtil;
import org.eclipse.emf.henshin.interpreter.ui.debug.RuleLaunchTab;
import org.eclipse.emf.henshin.interpreter.ui.util.ParameterConfig;
import org.eclipse.emf.henshin.interpreter.ui.util.TransformOperation;
import org.eclipse.emf.henshin.interpreter.ui.wizard.ModelSelector;
import org.eclipse.emf.henshin.interpreter.ui.wizard.ParameterEditTable;
import org.eclipse.emf.henshin.interpreter.ui.wizard.UnitSelector;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.ParameterKind;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class LaunchRuleControl {
    protected static int CONTROL_OFFSET = 5;
    ModelSelector moduleSelector;
    UnitSelector unitSelector;
    ModelSelector inputSelector;
    ModelSelector outputSelector;
    ParameterEditTable parameterEditor;
    Button openCompare;
    protected Unit initialUnit;
    protected Module module;
    protected List<Unit> allUnits;
    protected List<Unit> outerUnits;
    protected TransformOperation transformOperation;

    public Composite createControl(Composite parent, final RuleLaunchTab parentTab) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        this.transformOperation = new TransformOperation();
        IResource selected = null;
        if (this.module == null) {
            this.moduleSelector = new ModelSelector(container, selected, false);
            this.moduleSelector.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
            ((Group)this.moduleSelector.getControl()).setText("Module (.henshin file)");
            this.moduleSelector.addModelSelectorListener(new ModelSelector.ModelSelectorListener(){

                @Override
                public boolean modelURIChanged(String modulePath) {
                    HenshinResourceSet resourceSet = new HenshinResourceSet();
                    try {
                        URI uri = URI.createURI((String)modulePath);
                        LaunchRuleControl.this.module = resourceSet.getModule(uri, false);
                        LaunchRuleControl.this.updateUnitSelector();
                        parentTab.updateLaunchConfigurationDialog();
                        return true;
                    }
                    catch (RuntimeException runtimeException) {
                        LaunchRuleControl.this.clearModule();
                        return false;
                    }
                }
            });
        } else {
            String path = this.module.eResource().getURI().toPlatformString(true);
            selected = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        }
        this.unitSelector = new UnitSelector(container);
        this.unitSelector.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.inputSelector = new ModelSelector(container, selected, false);
        this.inputSelector.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.outputSelector = new ModelSelector(container, selected, true);
        this.outputSelector.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.inputSelector.addModelSelectorListener(new ModelSelector.ModelSelectorListener(){

            @Override
            public boolean modelURIChanged(String modelURI) {
                String output = LaunchRuleControl.this.deriveOutputURI(modelURI);
                if (output != null) {
                    LaunchRuleControl.this.outputSelector.setModelURI(output);
                }
                parentTab.updateLaunchConfigurationDialog();
                return true;
            }
        });
        this.parameterEditor = new ParameterEditTable(container);
        this.parameterEditor.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.parameterEditor.addParameterChangeListener(new ParameterEditTable.ParameterChangeListener(){

            @Override
            public void parameterChanged(ParameterConfig paramCfg) {
                LaunchRuleControl.this.transformOperation.getParameterConfiguration(paramCfg.getName()).setValue(paramCfg.getValue());
                LaunchRuleControl.this.transformOperation.getParameterConfiguration(paramCfg.getName()).setType(paramCfg.getType());
                LaunchRuleControl.this.transformOperation.getParameterConfiguration(paramCfg.getName()).setUnset(paramCfg.isUnset());
                parentTab.updateLaunchConfigurationDialog();
            }
        });
        this.openCompare = new Button(container, 32);
        this.openCompare.setLayoutData((Object)new GridData(4, 4, true, false));
        this.openCompare.setText("Open Compare");
        this.openCompare.setSelection(true);
        this.openCompare.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                parentTab.updateLaunchConfigurationDialog();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.inputSelector.getBrowseWorkspaceButton().setFocus();
        this.unitSelector.addUnitSelectionListener(new UnitSelector.UnitSelectionListener(){

            @Override
            public boolean unitSelected(int idx, boolean showInnerUnits) {
                Unit unit = showInnerUnits ? LaunchRuleControl.this.allUnits.get(idx) : LaunchRuleControl.this.outerUnits.get(idx);
                LaunchRuleControl.this.transformOperation.setUnit(unit, ParamUtil.getParameterPreferences(unit));
                for (ParameterConfig parameterConfig : LaunchRuleControl.this.transformOperation.getParameterConfigurations()) {
                    if (parameterConfig.getKind() == ParameterKind.IN || parameterConfig.getKind() == ParameterKind.INOUT) {
                        parameterConfig.setUnset(false);
                    }
                    if (parameterConfig.getKind() != ParameterKind.OUT && parameterConfig.getKind() != ParameterKind.VAR) continue;
                    parameterConfig.setUnset(true);
                }
                LaunchRuleControl.this.parameterEditor.setParameters(LaunchRuleControl.this.transformOperation.getParameterConfigurations());
                parentTab.updateLaunchConfigurationDialog();
                return false;
            }
        });
        return container;
    }

    private void updateUnitSelector() {
        this.allUnits = new ArrayList<Unit>();
        this.allUnits.addAll((Collection<Unit>)this.module.getUnits());
        this.outerUnits = new ArrayList<Unit>();
        ArrayList<String> selectableUnitLabels = new ArrayList<String>();
        ArrayList<String> outerUnitLabels = new ArrayList<String>();
        int initIdx = -1;
        int idx = 0;
        Unit selectedUnit = this.initialUnit;
        for (Unit unit : this.allUnits) {
            String unitLabel = unit.toString();
            selectableUnitLabels.add(unitLabel);
            boolean isOuterUnit = true;
            for (Unit outerUnit : this.allUnits) {
                if (!outerUnit.getSubUnits(true).contains((Object)unit)) continue;
                isOuterUnit = false;
                break;
            }
            if (isOuterUnit) {
                this.outerUnits.add(unit);
                outerUnitLabels.add(unitLabel);
            }
            if (this.initialUnit != null) {
                if (this.initialUnit == unit) {
                    initIdx = idx;
                    selectedUnit = unit;
                }
            } else if (initIdx < 0 && unit.getName() != null && unit.getName().toLowerCase().equals("main")) {
                initIdx = idx;
                selectedUnit = unit;
            }
            ++idx;
        }
        if (initIdx < 0) {
            initIdx = 0;
            selectedUnit = this.allUnits.get(0);
        }
        if (selectedUnit != null) {
            this.transformOperation.setUnit(selectedUnit, ParamUtil.getParameterPreferences(selectedUnit));
        }
        if (selectedUnit != null) {
            this.parameterEditor.setParameters(this.transformOperation.getParameterConfigurations());
        }
        this.unitSelector.setSelectableUnits(selectableUnitLabels.toArray(new String[0]), outerUnitLabels.toArray(new String[0]));
        this.unitSelector.setSelection(initIdx);
    }

    private void clearModule() {
        this.unitSelector.setSelectableUnits(new String[0], new String[0]);
        this.parameterEditor.setParameters(new ArrayList<ParameterConfig>(0));
    }

    private String deriveOutputURI(String inputUri) {
        try {
            URI uri = URI.createURI((String)inputUri);
            String fileExt = uri.fileExtension();
            uri = uri.trimFileExtension();
            uri = URI.createURI((String)(String.valueOf(uri.toString()) + "_transformed")).appendFileExtension(fileExt);
            return uri.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

