/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.jit;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.matching.jit.AbstractJITMatcherCompiler;
import org.eclipse.emf.henshin.interpreter.matching.jit.JITMatcher;
import org.eclipse.emf.henshin.interpreter.matching.jit.JITMatcherCompiler;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class TreeJITMatcherCompiler
extends AbstractJITMatcherCompiler {
    @Override
    protected boolean generateNextMatchMethod(Rule rule, AbstractJITMatcherCompiler.MatchingCodeGenerator gen) {
        Node root = null;
        for (Node node : rule.getLhs().getNodes()) {
            if (node.getOutgoing().size() != rule.getLhs().getEdges().size() || node.getOutgoing().size() != rule.getLhs().getNodes().size() - 1) continue;
            root = node;
            break;
        }
        if (root == null) {
            return false;
        }
        this.initRuleFields(rule, gen);
        gen.matcherFields.println("List<EObject> rootDomain = graph.getDomain(" + this.typeField((EObject)root) + ", false);");
        for (Node node : rule.getLhs().getNodes()) {
            gen.matcherFields.println("int " + this.indexField((EObject)node) + " = 0;");
        }
        gen.matcherCode.println("boolean valid = false;");
        gen.matcherCode.println("while (!valid) {");
        gen.matcherCode.println("  if (" + this.indexField((EObject)root) + "<rootDomain.size()) {");
        gen.matcherCode.println("    break;");
        gen.matcherCode.println("  }");
        gen.matcherCode.println("  EObject root = rootDomain.get(" + this.indexField((EObject)root) + ");");
        for (Node node : rule.getLhs().getNodes()) {
            if (node != root) continue;
        }
        gen.matcherCode.println("}");
        gen.matcherCode.println("if (!valid) {");
        gen.matcherCode.println("  return null;");
        gen.matcherCode.println("}");
        gen.matcherCode.println("Match rootMatch = new MatchImpl(" + this.objField((EObject)rule) + ");");
        gen.matcherCode.println("return rootMatch;");
        return true;
    }

    private boolean generateMultiRuleCode(Rule rule, Node parent, AbstractJITMatcherCompiler.MatchingCodeGenerator gen) {
        if (rule.getMultiRules().isEmpty()) {
            return true;
        }
        if (rule.getMultiRules().size() > 1) {
            return false;
        }
        Rule multiRule = (Rule)rule.getMultiRules().get(0);
        Graph multiLhs = multiRule.getLhs();
        EList multiNodes = multiLhs.getNodes();
        EList multiEdges = multiLhs.getEdges();
        MappingList multiMappings = multiRule.getMultiMappings();
        if (multiNodes.size() != 2) {
            return false;
        }
        Node parentImage = multiMappings.getImage(parent, multiLhs);
        if (parentImage == null) {
            return false;
        }
        int childIndex = multiNodes.get(0) == parentImage ? 1 : 0;
        Node child = (Node)multiNodes.get(childIndex);
        if (multiMappings.getOrigin(child) != null) {
            return false;
        }
        if (multiEdges.size() != 1) {
            return false;
        }
        Edge edge = (Edge)multiLhs.getEdges().get(0);
        if (multiMappings.getOrigin(edge) != null) {
            return false;
        }
        return edge.getSource() == parentImage && edge.getTarget() == child;
    }

    public static void main(String[] args) throws Throwable {
        HenshinResourceSet resourceSet = new HenshinResourceSet("../org.eclipse.emf.henshin.examples/src/org/eclipse/emf/henshin/examples/probbroadcast");
        Rule rule = (Rule)resourceSet.getModule("probbroadcast.henshin", false).getUnit("send");
        JITMatcher finder = JITMatcherCompiler.INSTANCE.generateMatcher(rule, null);
        EGraphImpl graph = new EGraphImpl(resourceSet.getEObject("init-grid4x4.xmi"));
        for (Match match : finder.findMatches(graph)) {
            System.out.println(match);
        }
    }
}

