/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.conflict;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.multicda.cda.Pushout;
import org.eclipse.emf.henshin.multicda.cda.units.Atom;
import org.eclipse.emf.henshin.multicda.cda.units.Reason;

public class EssentialConflictReason
extends Reason {
    Set<Atom> additionalConflictAtoms;

    public EssentialConflictReason(Reason initialReason, Node boundaryNodeOfCA, Node usedNodeInLhsOfR2, Atom.ConflictAtom additionalConflictAtom) {
        super(initialReason);
        HenshinFactory henshinFactory = HenshinFactory.eINSTANCE;
        Node boundaryNodeOfRule1 = additionalConflictAtom.getMappingIntoRule1(boundaryNodeOfCA).getImage();
        String nameOfNewBoundaryNode = String.valueOf(boundaryNodeOfRule1.getName()) + "_" + usedNodeInLhsOfR2.getName();
        Node newBoundaryNodeInSpan = henshinFactory.createNode(this.graph, boundaryNodeOfCA.getType(), nameOfNewBoundaryNode);
        Mapping mappingInR1 = henshinFactory.createMapping(newBoundaryNodeInSpan, boundaryNodeOfRule1);
        this.mappingsInRule1.add(mappingInR1);
        Mapping mappingInR2 = henshinFactory.createMapping(newBoundaryNodeInSpan, usedNodeInLhsOfR2);
        this.mappingsInRule2.add(mappingInR2);
        this.additionalConflictAtoms = new HashSet<Atom>();
        this.additionalConflictAtoms.add(additionalConflictAtom);
        if (initialReason instanceof EssentialConflictReason) {
            this.additionalConflictAtoms.addAll(((EssentialConflictReason)initialReason).getAdditionallyInvolvedConflictAtoms());
        }
    }

    public EssentialConflictReason(Reason initialReason) {
        super(initialReason);
        this.additionalConflictAtoms = new HashSet<Atom>();
    }

    public Set<Node> getLhsNodesOfR2UsedByAdditionalCAs() {
        HashSet<Node> result = new HashSet<Node>();
        for (Atom ca : this.additionalConflictAtoms) {
            Set<Mapping> mappingsInRule2 = ca.getMappingsInRule2();
            for (Mapping mappingInRule2 : mappingsInRule2) {
                result.add(mappingInRule2.getImage());
            }
        }
        return result;
    }

    public Set<Node> getUsedLhsNodesOfR2() {
        HashSet<Node> result = new HashSet<Node>();
        for (Mapping map : this.mappingsInRule2) {
            result.add(map.getImage());
        }
        return result;
    }

    public Set<Atom> getAdditionallyInvolvedConflictAtoms() {
        return this.additionalConflictAtoms;
    }

    public Pushout getPushoutResult() {
        return new Pushout(this.getRule1(), this, this.getRule2());
    }
}

