/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.preprocessing;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.impl.HenshinFactoryImpl;
import org.eclipse.emf.henshin.preprocessing.RulePair;

public class NonDeletingPreparator {
    public static List<RulePair> prepareNonDeletingVersions(List<Rule> rules) {
        HenshinFactoryImpl henshinFactory = new HenshinFactoryImpl();
        LinkedList<RulePair> copiesOfRulesWithoutDeletion = new LinkedList<RulePair>();
        for (Rule ruleToCopy : rules) {
            EcoreUtil.Copier copierForRule = new EcoreUtil.Copier();
            Rule copyOfRule = (Rule)copierForRule.copy((EObject)ruleToCopy);
            copyOfRule.setDescription("_");
            copierForRule.copyReferences();
            MappingList mappings = copyOfRule.getMappings();
            mappings.clear();
            for (Node nodeInLhs : copyOfRule.getLhs().getNodes()) {
                nodeInLhs.getAttributes().clear();
            }
            EcoreUtil.Copier copierForLhsGraph = new EcoreUtil.Copier();
            Graph copiedLhs = (Graph)copierForLhsGraph.copy((EObject)copyOfRule.getLhs());
            copierForLhsGraph.copyReferences();
            copiedLhs.setName("Rhs");
            copyOfRule.setRhs(copiedLhs);
            for (Node nodeInLhsOfCopiedRule : copyOfRule.getLhs().getNodes()) {
                Node nodeInNewRhs = (Node)copierForLhsGraph.get((Object)nodeInLhsOfCopiedRule);
                Mapping createdMapping = henshinFactory.createMapping(nodeInLhsOfCopiedRule, nodeInNewRhs);
                mappings.add((Object)createdMapping);
            }
            copiesOfRulesWithoutDeletion.add(new RulePair(copyOfRule, ruleToCopy));
        }
        return copiesOfRulesWithoutDeletion;
    }

    public static List<Rule> prepareNoneDeletingsVersionsRules(List<Rule> rules) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        List<RulePair> pairs = NonDeletingPreparator.prepareNonDeletingVersions(rules);
        for (RulePair rulePair : pairs) {
            result.add(rulePair.getCopy());
        }
        return result;
    }

    public static Rule prepareNoneDeletingsVersionsRules(Rule rule) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        result.add(rule);
        List<RulePair> pairs = NonDeletingPreparator.prepareNonDeletingVersions(result);
        return pairs.get(0).getCopy();
    }
}

