/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.normalize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinEdge;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinGraph;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinNode;
import org.eclipse.emf.henshin.variability.mergein.normalize.InputRuleNotSupportedException;
import org.eclipse.emf.henshin.variability.mergein.normalize.RuleToHenshinGraphMap;

public class HenshinGraphFactory {
    private static HenshinGraphFactory instance = new HenshinGraphFactory();

    private HenshinGraphFactory() {
    }

    public static HenshinGraphFactory getInstance() {
        return instance;
    }

    public HenshinGraph createIntegratedGraph(Rule rule, boolean includeRhs) throws InputRuleNotSupportedException {
        this.checkPrecondition(rule);
        HenshinGraph result = new HenshinGraph();
        this.addGraphElementsToResult(rule, result, includeRhs);
        return result;
    }

    private void addGraphElementsToResult(Rule rule, HenshinGraph result, boolean includeRhs) {
        for (Node n : this.getNodes(rule)) {
            if (this.isRelevant((GraphElement)n, includeRhs)) {
                HenshinNode node = new HenshinNode(result, (EObject)n.getType(), n.getAction().getType(), "");
                result.addVertex(n, node);
            }
            for (Attribute a : n.getAttributes()) {
                if (!this.isRelevant((GraphElement)a, includeRhs)) continue;
                result.addAttribute(a, a.getAction().getType(), "");
            }
        }
        for (Edge e : this.getEdges(rule)) {
            if (!this.isRelevant((GraphElement)e, includeRhs)) continue;
            Node source = e.getSource().getActionNode();
            Node target = e.getTarget().getActionNode();
            HenshinEdge integratedEdge = new HenshinEdge(result, e.getType(), e.getAction().getType(), "", false);
            result.addEdge(source, target, e, integratedEdge);
        }
    }

    private List<Node> getNodes(Rule rule) {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll((Collection<Node>)rule.getLhs().getNodes());
        result.addAll((Collection<Node>)rule.getRhs().getNodes());
        for (NestedCondition cond : rule.getLhs().getNestedConditions()) {
            result.addAll((Collection<Node>)cond.getConclusion().getNodes());
        }
        return result;
    }

    private List<Edge> getEdges(Rule rule) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        result.addAll((Collection<Edge>)rule.getLhs().getEdges());
        result.addAll((Collection<Edge>)rule.getRhs().getEdges());
        for (NestedCondition cond : rule.getLhs().getNestedConditions()) {
            result.addAll((Collection<Edge>)cond.getConclusion().getEdges());
        }
        return result;
    }

    private boolean isRelevant(GraphElement ge, boolean includeRhs) {
        if (ge.getAction() == null) {
            return false;
        }
        Action.Type type = ge.getAction().getType();
        if (type == Action.Type.DELETE || type == Action.Type.PRESERVE) {
            return true;
        }
        if (type == Action.Type.FORBID || type == Action.Type.REQUIRE) {
            return true;
        }
        if (type == Action.Type.CREATE) {
            return includeRhs;
        }
        return false;
    }

    private void checkPrecondition(Rule rule) throws InputRuleNotSupportedException {
        for (NestedCondition nac : rule.getLhs().getNACs()) {
            if (nac.getConclusion().getNestedConditions().isEmpty()) continue;
            throw new InputRuleNotSupportedException("Currently not supporting nesting of application conditions.");
        }
        for (NestedCondition pac : rule.getLhs().getPACs()) {
            if (pac.getConclusion().getNestedConditions().isEmpty()) continue;
            throw new InputRuleNotSupportedException("Currently not supporting nesting of application conditions.");
        }
    }

    public RuleToHenshinGraphMap createIntegratedGraphs(List<Rule> rules, boolean includeRhs) {
        RuleToHenshinGraphMap result = new RuleToHenshinGraphMap();
        for (Rule rule : rules) {
            try {
                result.put(rule, this.createIntegratedGraph(rule, includeRhs));
            }
            catch (InputRuleNotSupportedException e) {
                System.out.println("Skipping rule " + rule.getName() + ": " + e.getMessage());
            }
        }
        return result;
    }
}

