/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.gc2ac.core;

import graph.Attribute;
import graph.Node;
import java.util.ArrayList;
import java.util.HashMap;
import laxcondition.Operator;
import nestedcondition.Morphism;
import nestedcondition.NestedConstraint;
import nestedcondition.NestedconditionFactory;
import nestedcondition.NodeMapping;
import nestedcondition.QuantifiedCondition;
import nestedcondition.Variable;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.AttributeCondition;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Not;
import org.eclipse.emf.henshin.model.Or;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Xor;
import org.eclipse.emf.henshin.ocl2ac.gc2ac.core.NestedConditionPreparer;
import org.eclipse.emf.henshin.ocl2ac.gc2ac.util.GraphAdapter;
import org.eclipse.emf.henshin.ocl2ac.gc2ac.util.Shifter;

public class Integrator {
    private nestedcondition.NestedCondition condition;
    private nestedcondition.NestedCondition shiftedCondition;
    private NestedConstraint copyOfShitferResult;
    private NestedConstraint copyOfPreparedShiftedCondition;
    private Rule rule;
    private EPackage typeModel;
    private graph.Graph emptyStartGraph;
    private Graph rhsGraph;
    private graph.Graph adaptedRHSGraph;
    private GraphAdapter graphAdapter;
    private Morphism emptyMorphism;
    private NestedConstraint constraint;
    private HashMap<graph.Graph, Graph> graphMap;
    private final NestedconditionFactory factory = NestedconditionFactory.eINSTANCE;
    private final HenshinFactory henshinFactory = HenshinFactory.eINSTANCE;
    public ArrayList<String> ncVariablesNames;
    private boolean enableOptimizer = false;

    public Integrator(NestedConstraint constraint, Rule rule) {
        if (rule.getModule().getImports().size() == 1 && rule.getModule().getImports().contains((Object)constraint.getTypeGraph())) {
            System.out.println("The class name: " + this.getClass().getSimpleName());
            System.out.println(constraint);
            System.out.println(rule);
            this.constraint = constraint;
            this.condition = constraint.getCondition();
            this.rule = rule;
            this.typeModel = constraint.getTypeGraph();
            this.rhsGraph = rule.getRhs();
            this.emptyStartGraph = constraint.getDomain();
            this.graphAdapter = new GraphAdapter(this.rhsGraph, this.typeModel);
            this.graphAdapter.adaptFromHenshin();
            this.adaptedRHSGraph = this.graphAdapter.getGraph();
            this.graphMap = new HashMap();
            this.graphMap.put(this.adaptedRHSGraph, this.rhsGraph);
            this.emptyMorphism = this.factory.createMorphism();
            this.emptyMorphism.setFrom(this.emptyStartGraph);
            this.emptyMorphism.setTo(this.adaptedRHSGraph);
            this.ncVariablesNames = new ArrayList();
        } else {
            System.out.println("Error when initializing Integrator: incompatible type graphs!");
            System.err.println("rule.getModule().getImports().size() " + rule.getModule().getImports().size());
            System.err.println("rule.getModule().getImports()" + rule.getModule().getImports());
            System.err.println("constraint.getTypeGraph() " + constraint.getTypeGraph());
        }
    }

    public void integrate() {
        if (this.canIntegrate()) {
            Shifter.reset();
            Shifter shifter = new Shifter(this.emptyMorphism, this.condition, this.typeModel);
            System.out.println(String.valueOf(this.getClass().getSimpleName()) + " " + this.enableOptimizer);
            if (this.enableOptimizer) {
                System.out.println("Integrator: Opt is activted");
                shifter.setEnableOptimizer(true, this.rule, this.constraint);
            }
            shifter.shift();
            this.shiftedCondition = shifter.getResult();
            if (this.shiftedCondition == null) {
                Shifter.reset();
                System.out.println("Return in The class name: " + this.getClass().getSimpleName() + "<-");
                return;
            }
            Shifter.reset();
            this.constraint.setDomain(this.shiftedCondition.getDomain());
            this.constraint.setCondition(this.shiftedCondition);
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            this.copyOfShitferResult = (NestedConstraint)copier.copy((EObject)this.constraint);
            copier.copyReferences();
            this.integrateNC2Rule();
        } else {
            System.out.println("Error when integrating: input is null!");
        }
    }

    private void integrateNC2Rule() {
        NestedConditionPreparer preparer = new NestedConditionPreparer(this.constraint);
        preparer.prepare();
        this.shiftedCondition = preparer.getCondition();
        this.constraint.setDomain(this.shiftedCondition.getDomain());
        this.constraint.setCondition(this.shiftedCondition);
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        this.copyOfPreparedShiftedCondition = (NestedConstraint)copier.copy((EObject)this.constraint);
        copier.copyReferences();
        Formula formula = this.translate2Formula(this.shiftedCondition);
        if (this.rhsGraph.getFormula() != null) {
            Formula existingFormula = this.rhsGraph.getFormula();
            And henshinAnd = this.henshinFactory.createAnd();
            this.rhsGraph.setFormula((Formula)henshinAnd);
            henshinAnd.setLeft(existingFormula);
            henshinAnd.setRight(formula);
        } else {
            this.rhsGraph.setFormula(formula);
        }
        this.getNCVaraibles();
        this.createHenAttributeConditions();
        this.addNCAttributeVariablesASParamsToHenRule();
    }

    private void getNCVaraibles() {
        for (Variable v : this.condition.getVariables()) {
            if (this.ncVariablesNames.contains(v.getName())) continue;
            this.ncVariablesNames.add(v.getName());
        }
    }

    private void createHenAttributeConditions() {
        HashMap<Parameter, Attribute> mapOfHenVar = this.graphAdapter.henVarMappingsToNcAttribute;
        if (mapOfHenVar != null) {
            for (Parameter henVar : mapOfHenVar.keySet()) {
                String ncAttributeValue;
                Attribute ncAttribute = mapOfHenVar.get(henVar);
                AttributeCondition attCond = this.henshinFactory.createAttributeCondition();
                String stOp = ncAttribute.getOp();
                if (stOp.equalsIgnoreCase("<>")) {
                    stOp = "!=";
                }
                if ((ncAttributeValue = ncAttribute.getValue()).isEmpty() && ncAttribute.getType().getEType().equals(EcorePackage.Literals.ESTRING)) {
                    ncAttributeValue = "\"\"";
                }
                attCond.setConditionText(String.valueOf(henVar.getName()) + stOp + ncAttributeValue);
                this.rule.getAttributeConditions().add((Object)attCond);
                this.rule.getParameters().add((Object)henVar);
            }
        }
    }

    private void addNCAttributeVariablesASParamsToHenRule() {
        for (String param : this.ncVariablesNames) {
            Parameter henParam = this.henshinFactory.createParameter(param);
            if (this.rule.getParameters().contains((Object)henParam)) continue;
            this.rule.getParameters().add((Object)henParam);
        }
    }

    private Formula translate2Formula(nestedcondition.NestedCondition cond) {
        if (cond instanceof nestedcondition.Formula) {
            nestedcondition.Formula ncFormula = (nestedcondition.Formula)cond;
            return this.translateFormula2Formula(ncFormula);
        }
        if (cond instanceof QuantifiedCondition) {
            QuantifiedCondition qCond = (QuantifiedCondition)cond;
            return this.translateQuantifiedCondition2Formula(qCond);
        }
        return null;
    }

    private Formula translateQuantifiedCondition2Formula(QuantifiedCondition qCond) {
        NestedCondition henshinNC = this.henshinFactory.createNestedCondition();
        this.graphAdapter = new GraphAdapter(qCond.getCodomain());
        this.graphAdapter.adaptToHenshin();
        Graph henshinGraph = this.graphAdapter.getHenshinGraph();
        this.graphMap.put(qCond.getCodomain(), henshinGraph);
        henshinNC.setConclusion(henshinGraph);
        henshinNC.getMappings().addAll(this.createMappings(qCond.getMorphism()));
        Formula henshinFormula = this.translate2Formula(qCond.getCondition());
        if (henshinFormula != null) {
            henshinGraph.setFormula(henshinFormula);
        }
        return henshinNC;
    }

    private EList<Mapping> createMappings(Morphism morphism) {
        BasicEList mappings = new BasicEList();
        for (NodeMapping nm : morphism.getNodeMappings()) {
            org.eclipse.emf.henshin.model.Node sourceNode = this.getNode(this.graphMap.get(morphism.getFrom()), nm.getOrigin());
            org.eclipse.emf.henshin.model.Node targetNode = this.getNode(this.graphMap.get(morphism.getTo()), nm.getImage());
            Mapping mapping = this.henshinFactory.createMapping();
            mapping.setOrigin(sourceNode);
            mapping.setImage(targetNode);
            mappings.add((Object)mapping);
        }
        return mappings;
    }

    private org.eclipse.emf.henshin.model.Node getNode(Graph graph, Node node) {
        for (org.eclipse.emf.henshin.model.Node henshinNode : graph.getNodes()) {
            if (!node.getName().equals(henshinNode.getName()) || node.getType() != henshinNode.getType()) continue;
            return henshinNode;
        }
        return null;
    }

    private Formula translateFormula2Formula(nestedcondition.Formula ncFormula) {
        if (ncFormula.getOperator().equals((Object)Operator.NOT)) {
            Not henshinNot = this.henshinFactory.createNot();
            Formula henshinFormula = this.translate2Formula((nestedcondition.NestedCondition)ncFormula.getArguments().get(0));
            henshinNot.setChild(henshinFormula);
            return henshinNot;
        }
        Formula henshinFormula1 = this.translate2Formula((nestedcondition.NestedCondition)ncFormula.getArguments().get(0));
        Formula henshinFormula2 = this.translate2Formula((nestedcondition.NestedCondition)ncFormula.getArguments().get(1));
        if (ncFormula.getOperator().equals((Object)Operator.AND)) {
            And henshinAnd = this.henshinFactory.createAnd();
            henshinAnd.setLeft(henshinFormula1);
            henshinAnd.setRight(henshinFormula2);
            return henshinAnd;
        }
        if (ncFormula.getOperator().equals((Object)Operator.OR)) {
            Or henshinOr = this.henshinFactory.createOr();
            henshinOr.setLeft(henshinFormula1);
            henshinOr.setRight(henshinFormula2);
            return henshinOr;
        }
        if (ncFormula.getOperator().equals((Object)Operator.XOR)) {
            Xor henshinXor = this.henshinFactory.createXor();
            henshinXor.setLeft(henshinFormula1);
            henshinXor.setRight(henshinFormula2);
            return henshinXor;
        }
        return null;
    }

    private boolean canIntegrate() {
        return this.condition != null && this.emptyMorphism != null;
    }

    public Rule getRule() {
        return this.rule;
    }

    public nestedcondition.NestedCondition getShiftedCondition() {
        return this.shiftedCondition;
    }

    public NestedConstraint getCopyShitferResult() {
        return this.copyOfShitferResult;
    }

    public NestedConstraint getCopyPreparedShiftedCondition() {
        return this.copyOfPreparedShiftedCondition;
    }

    public boolean isEnableOptimizer() {
        return this.enableOptimizer;
    }

    public void setEnableOptimizer(boolean enableOptimizer) {
        this.enableOptimizer = enableOptimizer;
    }
}

