/*
 * Decompiled with CFR 0.152.
 */
package laxcondition.util;

import java.util.Map;
import laxcondition.Condition;
import laxcondition.Formula;
import laxcondition.LaxCondition;
import laxcondition.LaxconditionPackage;
import laxcondition.Operator;
import laxcondition.QuantifiedLaxCondition;
import laxcondition.Quantifier;
import laxcondition.True;
import laxcondition.Variable;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class LaxconditionValidator
extends EObjectValidator {
    public static final LaxconditionValidator INSTANCE = new LaxconditionValidator();
    public static final String DIAGNOSTIC_SOURCE = "laxcondition";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String CONDITION__TYPE_GRAPH_CONSISTENCY__EEXPRESSION = "graph_0::Graph.allInstances() -> forAll(g|g.typegraph = self.typeGraph)";
    protected static final String QUANTIFIED_LAX_CONDITION__HOST_GRAPH_CONSISTENCY__EEXPRESSION = "self.graph.edges -> forAll(e|self.graph.nodes -> includes(e.source) and self.graph.nodes -> includes(e.target))";
    protected static final String FORMULA__ONE_ARGUMENT_FOR_NOT__EEXPRESSION = "(self.op = Operator::NOT) implies (self.arguments -> size() = 1)";
    protected static final String FORMULA__AT_LEAST_TWO_ARGUMENT_FOR_ANDOR__EEXPRESSION = "((self.op = Operator::AND) or (self.op = Operator::OR)) implies (self.arguments -> size() > 1)";
    protected static final String FORMULA__TWO_ARGUMENT_FOR_IMPLEQUALXOR__EEXPRESSION = "((self.op = Operator::IMPLIES) or (self.op = Operator::EQUIVALENT) or (self.op = Operator::XOR)) implies (self.arguments -> size() = 2)";

    protected EPackage getEPackage() {
        return LaxconditionPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateCondition((Condition)value, diagnostics, context);
            }
            case 1: {
                return this.validateLaxCondition((LaxCondition)value, diagnostics, context);
            }
            case 2: {
                return this.validateQuantifiedLaxCondition((QuantifiedLaxCondition)value, diagnostics, context);
            }
            case 3: {
                return this.validateTrue((True)value, diagnostics, context);
            }
            case 4: {
                return this.validateFormula((Formula)value, diagnostics, context);
            }
            case 5: {
                return this.validateVariable((Variable)value, diagnostics, context);
            }
            case 6: {
                return this.validateQuantifier((Quantifier)((Object)value), diagnostics, context);
            }
            case 7: {
                return this.validateOperator((Operator)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateCondition(Condition condition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(condition, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(condition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(condition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(condition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(condition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(condition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(condition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(condition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(condition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCondition_TypeGraphConsistency(condition, diagnostics, context);
        }
        return result;
    }

    public boolean validateCondition_TypeGraphConsistency(Condition condition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(LaxconditionPackage.Literals.CONDITION, condition, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "TypeGraphConsistency", CONDITION__TYPE_GRAPH_CONSISTENCY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateLaxCondition(LaxCondition laxCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(laxCondition, diagnostics, context);
    }

    public boolean validateQuantifiedLaxCondition(QuantifiedLaxCondition quantifiedLaxCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(quantifiedLaxCondition, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(quantifiedLaxCondition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(quantifiedLaxCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(quantifiedLaxCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(quantifiedLaxCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(quantifiedLaxCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(quantifiedLaxCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(quantifiedLaxCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(quantifiedLaxCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateQuantifiedLaxCondition_HostGraphConsistency(quantifiedLaxCondition, diagnostics, context);
        }
        return result;
    }

    public boolean validateQuantifiedLaxCondition_HostGraphConsistency(QuantifiedLaxCondition quantifiedLaxCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(LaxconditionPackage.Literals.QUANTIFIED_LAX_CONDITION, quantifiedLaxCondition, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "HostGraphConsistency", QUANTIFIED_LAX_CONDITION__HOST_GRAPH_CONSISTENCY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateTrue(True true_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(true_, diagnostics, context);
    }

    public boolean validateFormula(Formula formula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(formula, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(formula, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormula_OneArgumentForNOT(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormula_AtLeastTwoArgumentForANDOR(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormula_TwoArgumentForIMPLEQUALXOR(formula, diagnostics, context);
        }
        return result;
    }

    public boolean validateFormula_OneArgumentForNOT(Formula formula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(LaxconditionPackage.Literals.FORMULA, formula, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "OneArgumentForNOT", FORMULA__ONE_ARGUMENT_FOR_NOT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateFormula_AtLeastTwoArgumentForANDOR(Formula formula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(LaxconditionPackage.Literals.FORMULA, formula, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "AtLeastTwoArgumentForANDOR", FORMULA__AT_LEAST_TWO_ARGUMENT_FOR_ANDOR__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateFormula_TwoArgumentForIMPLEQUALXOR(Formula formula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(LaxconditionPackage.Literals.FORMULA, formula, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "TwoArgumentForIMPLEQUALXOR", FORMULA__TWO_ARGUMENT_FOR_IMPLEQUALXOR__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateVariable(Variable variable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(variable, diagnostics, context);
    }

    public boolean validateQuantifier(Quantifier quantifier, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateOperator(Operator operator, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

