/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.utils.printer;

import graph.util.extensions.GraphPrinter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import laxcondition.Operator;
import laxcondition.Quantifier;
import nestedcondition.Formula;
import nestedcondition.NestedCondition;
import nestedcondition.NestedConstraint;
import nestedcondition.QuantifiedCondition;
import nestedcondition.True;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.henshin.ocl2ac.utils.printer.CopyCommand;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NestedConditionPrinter {
    private NestedConstraint constraint;
    private StringBuffer result;
    private int openBrackets;
    private boolean shortversion;
    private GraphPrinter graphPrinter;
    private String texfolderPath;
    private String outputFilePath;
    public static final String RIGHTARROW = "\\hookrightarrow";

    public NestedConditionPrinter(NestedConstraint constraint, boolean shortversion) {
        this.constraint = constraint;
        this.openBrackets = 0;
        this.shortversion = shortversion;
    }

    public void printDocument() {
        this.graphPrinter = new GraphPrinter(null);
        this.result = new StringBuffer(this.graphPrinter.printPreambel2());
        this.result.append("\\begin{document}\n");
        String constraintNameInLatx = this.constraint.getName();
        if (constraintNameInLatx.contains("_")) {
            constraintNameInLatx = constraintNameInLatx.replaceAll("_", "\\\\_");
        }
        if (this.shortversion) {
            // empty if block
        }
        this.result.append("$\\begin{array}{l} \n");
        this.printNestedCondition(this.constraint.getCondition());
        this.result.append("\n\\end{array}$");
        this.result.append("\n\\end{document}");
        this.saveFile();
    }

    private void printNestedCondition(NestedCondition condition) {
        if (condition instanceof QuantifiedCondition) {
            this.printQuantifiedCondition((QuantifiedCondition)condition);
        }
        if (condition instanceof True) {
            this.printTrue((True)condition);
        }
        if (condition instanceof Formula) {
            this.printFormula((Formula)condition);
        }
    }

    private void printQuantifiedCondition(QuantifiedCondition cond) {
        boolean isExists = cond.getQuantifier().equals((Object)Quantifier.EXISTS);
        boolean isTrue = cond.getCondition() instanceof True;
        if (isExists) {
            this.result.append("\\exists ");
        } else {
            this.result.append("\\forall ");
        }
        this.result.append(String.valueOf(this.left()) + " ");
        if (!this.shortversion) {
            this.graphPrinter = new GraphPrinter(cond.getDomain());
            this.result.append(this.graphPrinter.printGraph());
            this.result.append(" \\hookrightarrow ");
        }
        this.graphPrinter = new GraphPrinter(cond.getCodomain());
        this.result.append(this.graphPrinter.printGraph());
        if (!this.shortversion || !isTrue) {
            this.result.append(" , " + this.cr());
            this.printNestedCondition(cond.getCondition());
        }
        this.result.append(" " + this.right());
    }

    private void printFormula(Formula formula) {
        int i;
        if (formula.eContainer() instanceof Formula) {
            this.result.append(" (");
        }
        if (formula.getOperator().equals((Object)Operator.NOT)) {
            this.result.append("\\neg ");
            this.printNestedCondition((NestedCondition)formula.getArguments().get(0));
        }
        if (formula.getOperator().equals((Object)Operator.IMPLIES)) {
            this.printNestedCondition((NestedCondition)formula.getArguments().get(0));
            this.result.append(" " + this.cr() + "\\Rightarrow" + " ");
            this.printNestedCondition((NestedCondition)formula.getArguments().get(1));
        }
        if (formula.getOperator().equals((Object)Operator.EQUIVALENT)) {
            this.printNestedCondition((NestedCondition)formula.getArguments().get(0));
            this.result.append(" " + this.cr() + "$\\Leftrightarrow$" + " ");
            this.printNestedCondition((NestedCondition)formula.getArguments().get(1));
        }
        if (formula.getOperator().equals((Object)Operator.AND)) {
            this.printNestedCondition((NestedCondition)formula.getArguments().get(0));
            i = 1;
            while (i < formula.getArguments().size()) {
                this.result.append(" " + this.cr() + "\\land" + " ");
                this.printNestedCondition((NestedCondition)formula.getArguments().get(i));
                ++i;
            }
        }
        if (formula.getOperator().equals((Object)Operator.OR)) {
            this.printNestedCondition((NestedCondition)formula.getArguments().get(0));
            i = 1;
            while (i < formula.getArguments().size()) {
                this.result.append(" " + this.cr() + "\\lor" + " ");
                this.printNestedCondition((NestedCondition)formula.getArguments().get(i));
                ++i;
            }
        }
        if (formula.getOperator().equals((Object)Operator.XOR)) {
            this.printNestedCondition((NestedCondition)formula.getArguments().get(0));
            this.result.append(" " + this.cr() + "\\veebar" + " ");
            this.printNestedCondition((NestedCondition)formula.getArguments().get(1));
        }
        if (formula.eContainer() instanceof Formula) {
            this.result.append(") ");
        }
    }

    private void printTrue(True cond) {
        this.result.append("true");
    }

    private String right() {
        --this.openBrackets;
        return "\\right)";
    }

    private String left() {
        ++this.openBrackets;
        return "\\left(";
    }

    private String cr() {
        String ret = "\n";
        int i = 0;
        while (i < this.openBrackets) {
            ret = String.valueOf(ret) + "\\right. ";
            ++i;
        }
        ret = String.valueOf(ret) + "\\cr ";
        i = 0;
        while (i < this.openBrackets) {
            ret = String.valueOf(ret) + "\\left. ";
            ++i;
        }
        return String.valueOf(ret) + "\n";
    }

    private void saveFile() {
        String nameMark = null;
        URI uri = this.getActualProject().getLocationURI();
        this.texfolderPath = uri.getPath().concat("\\tex\\");
        File texFolderFile = new File(this.texfolderPath);
        if (!texFolderFile.exists()) {
            CopyCommand copyFileCommand = new CopyCommand(uri);
            copyFileCommand.copy();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        Date date = new GregorianCalendar().getTime();
        nameMark = "_" + sdf.format(date);
        nameMark = this.shortversion ? String.valueOf(nameMark) + "SV" : String.valueOf(nameMark) + "LV";
        this.outputFilePath = this.texfolderPath.concat("Constraint_" + this.constraint.getName() + nameMark + ".tex");
        File file = new File(this.getOutputFilePath());
        Writer writer = null;
        try {
            try {
                writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                writer.write(this.result.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    writer.close();
                    this.getActualProject().refreshLocal(2, null);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                writer.close();
                this.getActualProject().refreshLocal(2, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private IProject getActualProject() {
        IProject actualProject = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            try {
                IEditorInput input;
                IEditorPart editorPart = window.getActivePage().getActiveEditor();
                if (editorPart != null && (input = editorPart.getEditorInput()) instanceof IFileEditorInput) {
                    IFileEditorInput fileInput = (IFileEditorInput)input;
                    actualProject = fileInput.getFile().getProject();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return actualProject;
    }

    public String getOutputFilePath() {
        return this.outputFilePath;
    }
}

