/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.utils.printer.actions;

import java.io.IOException;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinModelCleaner;
import org.eclipse.emf.henshin.ocl2ac.utils.henshin.simplification.EquivalencesSimplifier;
import org.eclipse.emf.henshin.ocl2ac.utils.henshin.simplification.HenshinNACSimplifier;
import org.eclipse.emf.henshin.presentation.HenshinEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class HenshinNACSimplifierAction
implements IObjectActionDelegate {
    protected IWorkbenchPart workbenchPart;
    protected Rule rule;

    public void run(IAction action) {
        this.simplifyAC();
    }

    protected void simplifyAC() {
        long start = System.currentTimeMillis();
        if (this.rule.getLhs().getFormula() != null) {
            HenshinNACSimplifier.eliminateNotNotFromNAC(this.rule);
            HenshinNACSimplifier.simplifyOrGraphsInAC(this.rule);
            HenshinNACSimplifier.simplifyAndGraphsInAC(this.rule);
            HenshinNACSimplifier.eliminateNotNotFromNAC(this.rule);
            HenshinModelCleaner.cleanFormula((Formula)this.rule.getLhs().getFormula());
            new EquivalencesSimplifier(this.rule.getLhs().getFormula());
            HenshinModelCleaner.cleanFormula((Formula)this.rule.getLhs().getFormula());
            long stop = System.currentTimeMillis();
            try {
                this.rule.getModule().eResource().save(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Simplification", (String)("Simplification is finished. The Simplification time is: (" + (double)(stop - start) / 1000.0 + ") second(s)."));
        } else {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Simplification", (String)"The selected rule has no application condition.");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object first;
        this.rule = null;
        if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof Rule) {
            this.rule = (Rule)first;
        }
        action.setEnabled(this.rule != null);
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.workbenchPart = part instanceof HenshinEditor ? part : null;
        action.setEnabled(this.workbenchPart != null);
    }
}

